/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import utils.swing.components.LeftRightButtonInterface;
import utils.swing.customlaf.SHToggleButtonUI;

public class LeftRightToggleButtonUI
extends SHToggleButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new LeftRightToggleButtonUI();
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        if (text == null || text.length() <= 0) {
            return;
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.drawString(text, x, y);
        } else {
            g.drawString(text, x, y);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        String leftText = ((LeftRightButtonInterface)((Object)c)).getLeftText();
        String rightText = ((LeftRightButtonInterface)((Object)c)).getRightText();
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(g.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            Color rightColor;
            g.setColor(b.getForeground());
            if (leftText != null) {
                LeftRightToggleButtonUI.drawString(c, g, leftText, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
            }
            if ((rightColor = ((LeftRightButtonInterface)((Object)c)).getRightColour()) != null) {
                g.setColor(rightColor);
            }
            if (rightText != null) {
                LeftRightToggleButtonUI.drawString(c, g, rightText, c.getWidth() - this.getTextShiftOffset() - SwingUtilities.computeStringWidth(fm, rightText) - 10, textRect.y + fm.getAscent() + this.getTextShiftOffset());
            }
        } else {
            g.setColor(b.getBackground().brighter());
            if (leftText != null) {
                LeftRightToggleButtonUI.drawString(c, g, leftText, textRect.x, textRect.y + fm.getAscent());
            }
            if (rightText != null) {
                LeftRightToggleButtonUI.drawString(c, g, rightText, c.getWidth() - this.getTextShiftOffset() - SwingUtilities.computeStringWidth(fm, rightText) - 10, textRect.y + fm.getAscent() + this.getTextShiftOffset());
            }
            g.setColor(b.getBackground().darker());
            if (leftText != null) {
                LeftRightToggleButtonUI.drawString(c, g, leftText, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
            if (rightText != null) {
                LeftRightToggleButtonUI.drawString(c, g, rightText, c.getWidth() - this.getTextShiftOffset() - SwingUtilities.computeStringWidth(fm, rightText) - 10 - 1, textRect.y + fm.getAscent() + this.getTextShiftOffset() - 1);
            }
        }
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        this.paintText(g, (JComponent)b, textRect, text);
    }
}

