/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.ui;

import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import utils.swing.SwingStyleInterface;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.CheckBoxField;
import utils.swing.cui.ui.ConfigUI;

public class CheckBoxConfigUI
extends ConfigUI {
    private JComboBox box;

    public CheckBoxConfigUI(ResourceBundle bundle, SwingStyleInterface style, AbstractField.ChangeListener listener) {
        super(bundle, style, listener);
    }

    @Override
    public void loadConfigurationFrom(CUIField uiType) {
        CheckBoxField cField = (CheckBoxField)uiType;
        Boolean validOption = cField.getValidOption();
        if (validOption == null) {
            this.box.setSelectedIndex(0);
        } else if (validOption.booleanValue()) {
            this.box.setSelectedIndex(1);
        } else {
            this.box.setSelectedIndex(2);
        }
    }

    @Override
    public void saveConfigurationTo(CUIField type) {
        CheckBoxField cField = (CheckBoxField)type;
        if (this.box.getSelectedIndex() == 0) {
            cField.setValidOption(null);
        } else if (this.box.getSelectedIndex() == 1) {
            cField.setValidOption(new Boolean(true));
        } else if (this.box.getSelectedIndex() == 2) {
            cField.setValidOption(new Boolean(false));
        }
    }

    @Override
    public void initUI() {
        JLabel validationLabel = new JLabel(this.bundle.getString("CUI_COMBO_VALIDATE"));
        this.box = new JComboBox<String>(new String[]{this.bundle.getString("CUI_COMBO_VALIDATE_ANY"), this.bundle.getString("CUI_COMBO_VALIDATE_YES"), this.bundle.getString("CUI_COMBO_VALIDATE_NO")});
        this.rootComponent.add(validationLabel, 0, 0, 1, 1, 0, 1, 13, 0);
        this.rootComponent.add(this.box, 1, 0, 1, 1, 1, 1, 17, 0);
        this.box.addActionListener(this.actionChangeListener);
    }
}

