/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types.fields;

import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Element;
import utils.swing.components.messagefields.MessageTextArea;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.validators.RequiredValidator;
import utils.xml.XML14Util;

public class TextAreaField
extends AbstractField {
    public static final String TEXTAREAFIELD_TYPE = "textarea";
    public static final int DEFAULT_ROWS = 5;
    private MessageTextArea textArea;
    private JScrollPane pane;
    private String exampleValue;
    private String defaultValue;
    private boolean isRequired = false;
    private int rowCount = 5;

    public String getExampleValue() {
        return this.exampleValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public TextAreaField(String label, AbstractField.ChangeListener changeListener) {
        super(TEXTAREAFIELD_TYPE, label, changeListener);
        this.textArea.addKeyListener(this.proxyChangeListener);
    }

    @Override
    protected void initComponent() {
        this.textArea = new MessageTextArea(null, null);
        this.textArea.setTabSize(3);
        this.pane = new JScrollPane(this.textArea);
    }

    @Override
    public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
        return new ResultPair(this.label, this.textArea.getText());
    }

    @Override
    public ResultPair getStorableFilledOutData() {
        return new ResultPair(this.label, this.textArea.getText());
    }

    @Override
    public void setStorableFilledOutData(ResultPair data) {
        this.textArea.setText(data.getValue());
    }

    public void setRowCount(int count) {
        this.rowCount = count;
        this.textArea.setRows(this.rowCount);
    }

    @Override
    public JComponent getComponent() {
        return this.pane;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public void setExampleValue(String exampleValue) {
        this.exampleValue = exampleValue;
        this.textArea.setMessageText(exampleValue);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        if (defaultValue != null) {
            this.textArea.setText(defaultValue);
        } else {
            this.textArea.clear();
        }
    }

    public static CUIField fromXML(Element element, AbstractField.ChangeListener cl) {
        String rowString;
        String label = element.getAttribute("label");
        TextAreaField type = new TextAreaField(label, cl);
        type.setDefaultValue(XML14Util.getChildText(element, "Default", null));
        type.setExampleValue(XML14Util.getChildText(element, "Example", null));
        if (XML14Util.getChildText(element, "Required", null) != null) {
            type.setRequired(true);
        }
        if ((rowString = XML14Util.getChildText(element, "RowCount", null)) != null && rowString.length() > 0) {
            type.setRowCount(Integer.parseInt(rowString));
        }
        return type;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        if (isRequired) {
            this.addValidator(new RequiredValidator(isRequired));
        }
    }

    @Override
    public void toXML(StringBuffer buffer, int tabs) {
        if (this.defaultValue != null) {
            buffer.append(XML14Util.getIndent(tabs)).append("<Default>" + this.defaultValue + "</Default>\n");
        }
        if (this.exampleValue != null) {
            buffer.append(XML14Util.getIndent(tabs)).append("<Example>" + this.exampleValue + "</Example>\n");
        }
        if (this.isRequired) {
            buffer.append(XML14Util.getIndent(tabs)).append("<Required>" + Boolean.toString(true) + "</Required>\n");
        }
        buffer.append(XML14Util.getIndent(tabs)).append("<RowCount>" + this.rowCount + "</RowCount>\n");
    }

    @Override
    public void clearContents() {
        this.textArea.clear();
    }
}

