/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types;

import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import org.w3c.dom.Element;
import utils.swing.components.JWrapLabel;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.layout.GbPanel;
import utils.xml.XML14Util;

public class LabelField
implements CUIField {
    public static String LABEL_TYPE = "label";
    private final boolean rightOnly;
    protected String label;
    protected String displayLabel = null;
    private JWrapLabel wrapLabel = new JWrapLabel();
    private Insets layoutInsets;

    public LabelField(String label) {
        this(label, false);
    }

    public LabelField(String label, boolean rightOnly) {
        this.rightOnly = rightOnly;
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    @Override
    public String getDisplayLabel() {
        if (this.displayLabel == null) {
            return this.label;
        }
        return this.displayLabel;
    }

    @Override
    public String toXML(int tabs) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(XML14Util.getIndent(tabs));
        buffer.append("<CUIField type=\"").append(LABEL_TYPE).append("\" label=\"").append(XML14Util.escape(this.label)).append("\" right=\"").append(this.rightOnly).append("\"/>");
        return buffer.toString();
    }

    public static LabelField fromXML(Element element, AbstractField.ChangeListener cl) {
        String label = element.getAttribute("label");
        boolean right = false;
        try {
            String rightAttribute = element.getAttribute("right");
            if (rightAttribute != null) {
                right = Boolean.parseBoolean(rightAttribute);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new LabelField(label, right);
    }

    @Override
    public void populate(GbPanel panel, int X, int Y) {
        String displayLabel = this.getDisplayLabel();
        if (displayLabel.toLowerCase().trim().startsWith("<html>")) {
            this.wrapLabel.setText(displayLabel);
        } else {
            this.wrapLabel.setText("<html>" + displayLabel + "</html>");
        }
        Insets insets = this.layoutInsets != null ? (Insets)this.layoutInsets.clone() : (Insets)panel.getGbPanelInsets().clone();
        if (Y == 0) {
            insets.top = 0;
        }
        if (!this.rightOnly) {
            insets.right = 0;
            insets.left = 0;
            panel.add(this.wrapLabel, X, Y, 2, 1, 1, 0, 17, 2, insets);
        } else {
            insets.right = 0;
            panel.add(this.wrapLabel, X + 1, Y, 1, 1, 1, 0, 17, 2, insets);
        }
    }

    @Override
    public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
        return null;
    }

    @Override
    public void clearContents() {
    }

    @Override
    public void setStorableFilledOutData(ResultPair data) {
    }

    @Override
    public ResultPair getStorableFilledOutData() {
        return null;
    }

    public JLabel getBackingJLabel() {
        return this.wrapLabel;
    }

    @Override
    public void setLayoutInsets(Insets layoutInsets) {
        this.layoutInsets = layoutInsets;
    }
}

