/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types;

import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.LabelField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.CheckBoxField;
import utils.swing.cui.types.fields.ComboBoxField;
import utils.swing.cui.types.fields.RadioButtonField;
import utils.swing.cui.types.fields.TextAreaField;
import utils.swing.cui.types.fields.TextField;
import utils.xml.XML14Util;

public class CUIFieldRepository {
    public static final String FIELD_GROUP_TAG = "DetailsList";

    public static CUIField[] fieldsFromXML(String detailXML) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = builder.parse(new InputSource(new StringReader(detailXML)));
            Element root = dom.getDocumentElement();
            return CUIFieldRepository.loadChildrenOfElement(root, null);
        }
        catch (Throwable t) {
            return new CUIField[0];
        }
    }

    public static String fieldsToXML(CUIField[] fields, int tabs) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(XML14Util.getIndent(tabs)).append("<").append(FIELD_GROUP_TAG).append(">\n");
        for (int i = 0; i < fields.length; ++i) {
            buffer.append(fields[i].toXML(tabs + 1)).append("\n");
        }
        buffer.append(XML14Util.getIndent(tabs)).append("</").append(FIELD_GROUP_TAG).append(">\n");
        return buffer.toString();
    }

    public static CUIField[] loadChildrenOfElement(Element parent, AbstractField.ChangeListener cl) {
        NodeList list = parent.getElementsByTagName("CUIField");
        ArrayList<CUIField> allTypes = new ArrayList<CUIField>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            CUIField type = CUIFieldRepository.loadFromXML(element, null);
            allTypes.add(type);
        }
        CUIField[] allFields = new CUIField[allTypes.size()];
        allTypes.toArray(allFields);
        return allFields;
    }

    public static CUIField loadFromXML(Element element, AbstractField.ChangeListener cl) {
        String id = element.getAttribute("type");
        if (id == null) {
            return null;
        }
        CUIField type = null;
        if (id.equals(LabelField.LABEL_TYPE)) {
            type = LabelField.fromXML(element, cl);
        } else if (id.equals("checkbox")) {
            type = CheckBoxField.fromXML(element, cl);
        } else if (id.equals("combobox")) {
            type = ComboBoxField.fromXML(element, cl);
        } else if (id.equals("radiobutton")) {
            type = RadioButtonField.fromXML(element, cl);
        } else if (id.equals("textfield")) {
            type = TextField.fromXML(element, cl);
        } else if (id.equals("textarea")) {
            type = TextAreaField.fromXML(element, cl);
        }
        String width = element.getAttribute("width");
        if (width != null && width.length() > 0) {
            try {
                int widthInt = Integer.parseInt(width);
                if (type instanceof AbstractField) {
                    ((AbstractField)type).setWidthPercentage(widthInt);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return type;
    }

    public static void main(String[] args) {
        CUIField[] fields = new CUIField[]{new TextField("One", null), new TextField("Two", null)};
        System.out.println(CUIFieldRepository.fieldsFromXML(CUIFieldRepository.fieldsToXML(fields, 0)).length);
    }
}

