/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.path;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.components.path.elements.PathElement;
import utils.swing.customlaf.SHBorderFactory;

public class PathElementUI
extends JPanel {
    private PathElement element;
    private JLabel label;
    private static Border emptyBorder = SHBorderFactory.createEmptyBorder(4, 4, 4, 4);
    private static Color highlightedBackground = new Color(200, 220, 240);

    public PathElementUI(PathElement element) {
        this.element = element;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.initUI();
    }

    public PathElement getPathElement() {
        return this.element;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
    }

    @Override
    public Dimension getMinimumSize() {
        Insets borderInsets = this.getBorder().getBorderInsets(this);
        Dimension dim = super.getMinimumSize();
        if (this.element.getIcon() != null) {
            dim.width = this.element.getIcon().getIconWidth() + borderInsets.left + borderInsets.right;
        }
        return dim;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        return dim;
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    private void initUI() {
        this.setLayout(new GridLayout(1, 1));
        this.label = new JLabel(this.element.getText());
        this.add(this.label);
        this.label.setHorizontalAlignment(2);
        this.label.setIcon(this.element.getIcon());
        this.setBorder(emptyBorder);
        this.doLayout();
    }

    public void highlight() {
        this.setBackground(highlightedBackground);
        this.repaint();
    }

    public void unhighlight() {
        this.setBackground(null);
        this.repaint();
    }
}

