/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.messagefields;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.JTextComponent;

public class MessageFieldHandler
implements KeyListener,
FocusListener {
    protected JTextComponent delegate;
    private Color defaultColor;
    private Color grayColor;
    private String searchText;
    private FilterListener filterListener;
    private String lastNotifiedFilter = null;

    public String getSearchText() {
        return this.searchText;
    }

    public MessageFieldHandler(JTextComponent delegate, String message, FilterListener filterListener) {
        this.delegate = delegate;
        this.filterListener = filterListener;
        this.searchText = message;
        this.defaultColor = this.getDefaultTextColor();
        this.grayColor = Color.GRAY;
    }

    public void init() {
        this.delegate.setText(this.searchText);
        this.delegate.setForeground(this.grayColor);
        this.delegate.addKeyListener(this);
        this.delegate.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!this.hasEnteredText()) {
            this.delegate.setText("");
        }
        this.delegate.setForeground(this.defaultColor);
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.delegate.getText().length() == 0) {
            this.delegate.setText(this.searchText);
            this.delegate.setForeground(this.grayColor);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource().equals(this.delegate)) {
            String filter = null;
            String text = this.delegate.getText().trim();
            if (text.length() > 0) {
                filter = text;
            }
            boolean isEnter = e.getKeyCode() == 10;
            this.notifyListener(filter, isEnter);
        }
    }

    protected Color getDefaultTextColor() {
        return this.delegate.getForeground();
    }

    protected boolean isShowingMessage() {
        return this.delegate.getForeground().equals(this.grayColor);
    }

    private void notifyListener(String filter, boolean immediately) {
        if (this.filterListener == null) {
            return;
        }
        if (this.lastNotifiedFilter != null && filter == null || this.lastNotifiedFilter == null && filter != null || this.lastNotifiedFilter != null && !this.lastNotifiedFilter.equals(filter)) {
            this.lastNotifiedFilter = filter;
            this.filterListener.setFilter(filter, immediately);
        }
    }

    public void setMessageText(String message) {
        this.searchText = message;
        if (!this.hasEnteredText()) {
            this.delegate.setText(this.searchText);
            this.setGrayColor();
        }
    }

    public boolean hasEnteredText() {
        return this.delegate.getForeground().equals(this.defaultColor);
    }

    public void clear() {
        this.notifyListener(null, true);
    }

    public void setDefaultColor() {
        this.delegate.setForeground(this.defaultColor);
    }

    public void setGrayColor() {
        this.delegate.setForeground(this.grayColor);
    }

    public static interface FilterListener {
        public void setFilter(String var1, boolean var2);
    }
}

