/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.checklist;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import utils.swing.components.checklist.CheckListRenderer;

public abstract class JCheckList
extends JList {
    public JCheckList() {
        this.setCellRenderer(new CheckListRenderer(){

            @Override
            public boolean isObjectSelected(Object it) {
                return JCheckList.this.isObjectSelected(it);
            }
        });
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                if (index != -1 && JCheckList.this.getCellBounds(index, index).contains(event.getPoint())) {
                    Object it = list.getModel().getElementAt(index);
                    JCheckList.this.registerSelection(it);
                    list.repaint(list.getCellBounds(index, index));
                }
            }
        });
    }

    public abstract void registerSelection(Object var1);

    public abstract boolean isObjectSelected(Object var1);
}

