/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.animated.jlist;

import java.util.ArrayList;

public class Range1D {
    private ArrayList unmarkedRanges = new ArrayList();

    public Range1D(int min, int max) {
        this.unmarkedRanges.add(new Range(min, max));
    }

    public Range[] getUnmarkedRanges() {
        Range[] result = new Range[this.unmarkedRanges.size()];
        this.unmarkedRanges.toArray(result);
        return result;
    }

    public void markRange(int start, int end) {
        for (int i = 0; i < this.unmarkedRanges.size(); ++i) {
            Range unmarked = (Range)this.unmarkedRanges.get(i);
            if (unmarked.start < start && unmarked.end > end) {
                Range left = new Range(unmarked.start, start);
                Range right = new Range(end, unmarked.end);
                this.unmarkedRanges.remove(i);
                if (!left.isEmpty()) {
                    this.unmarkedRanges.add(i++, left);
                }
                if (!right.isEmpty()) {
                    this.unmarkedRanges.add(i++, right);
                }
                --i;
                continue;
            }
            if (unmarked.end < start || end < unmarked.start) continue;
            if (unmarked.start < start) {
                unmarked.end = start;
            } else {
                unmarked.start = end;
            }
            if (!unmarked.isEmpty()) continue;
            this.unmarkedRanges.remove(i);
            --i;
        }
    }

    public static void main(String[] args) {
        Range1D range = new Range1D(-50, 50);
        System.out.println(range.unmarkedRanges);
        range.markRange(-60, -40);
        System.out.println(range.unmarkedRanges);
        range.markRange(100, 200);
        System.out.println(range.unmarkedRanges);
        range.markRange(40, 60);
        System.out.println(range.unmarkedRanges);
        range.markRange(0, 10);
        System.out.println(range.unmarkedRanges);
    }

    class Range {
        int start;
        int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.start + " -> " + this.end;
        }

        public boolean isEmpty() {
            return this.start >= this.end;
        }
    }
}

