/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import utils.swing.components.LeftRightButtonInterface;
import utils.swing.customlaf.LeftRightToggleButtonUI;

public class LeftRightToggleButton
extends JToggleButton
implements LeftRightButtonInterface {
    public String leftText;
    public String rightText;
    private Color rightColour;
    private LeftRightToggleButtonUI ui = new LeftRightToggleButtonUI();

    public LeftRightToggleButton(String text, Icon imageIcon) {
        super(text, imageIcon);
        this.setLeftRightText(text, null);
        this.setUI(this.ui);
    }

    public LeftRightToggleButton() {
        this.setUI(this.ui);
    }

    @Override
    public void setLeftRightText(String leftText, String rightText) {
        this.leftText = leftText;
        this.rightText = rightText;
        if (leftText != null && rightText != null) {
            this.setText(leftText + " " + rightText);
        } else if (leftText != null) {
            this.setText(leftText);
        } else if (rightText != null) {
            this.setText(rightText);
        }
    }

    @Override
    public void setRightColour(Color rightColour) {
        this.rightColour = rightColour;
    }

    @Override
    public Color getRightColour() {
        return this.rightColour;
    }

    @Override
    public String getLeftText() {
        return this.leftText;
    }

    @Override
    public String getRightText() {
        return this.rightText;
    }
}

