/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import utils.swing.SwingUtil;
import utils.swing.components.LeftRightButtonInterface;
import utils.swing.customlaf.LeftRightButtonUI;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.layout.GbPanel;

public class LeftRightButton
extends JButton
implements LeftRightButtonInterface {
    public String leftText;
    public String rightText;
    private Color rightColour;
    private LeftRightButtonUI ui = new LeftRightButtonUI();

    public LeftRightButton(String text, Icon imageIcon) {
        super(text, imageIcon);
        this.setLeftRightText(text, null);
        this.setUI(this.ui);
    }

    public LeftRightButton() {
        this.setUI(this.ui);
    }

    @Override
    public void setLeftRightText(String leftText, String rightText) {
        this.leftText = leftText;
        this.rightText = rightText;
        if (leftText != null && rightText != null) {
            this.setText(leftText + " " + rightText);
        } else if (leftText != null) {
            this.setText(leftText);
        } else if (rightText != null) {
            this.setText(rightText);
        }
    }

    @Override
    public void setRightColour(Color rightColour) {
        this.rightColour = rightColour;
    }

    public static void main(String[] args) {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        Icon icon = UIManager.getIcon("OptionPane.informationIcon");
        LeftRightButton button = new LeftRightButton();
        button.setIcon(icon);
        button.setLeftRightText("123", "12");
        button.setUI(new LeftRightButtonUI());
        button.setHorizontalAlignment(2);
        button.setRightColour(Color.GRAY);
        LeftRightButton button2 = new LeftRightButton();
        button2.setLeftRightText("123", "12");
        button2.setUI(new LeftRightButtonUI());
        button2.setHorizontalAlignment(2);
        button2.setEnabled(false);
        SwingUtil.setWidth(button, 300);
        SwingUtil.setWidth(button2, 300);
        GbPanel panel = new GbPanel();
        panel.add(button, 0, 0, 1, 1, 1, 1, 10, 0);
        panel.add(button2, 0, 1, 1, 1, 1, 1, 10, 0);
        frame.getContentPane().add(panel);
        frame.setVisible(true);
    }

    @Override
    public Color getRightColour() {
        return this.rightColour;
    }

    @Override
    public String getLeftText() {
        return this.leftText;
    }

    @Override
    public String getRightText() {
        return this.rightText;
    }
}

