/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.layout.GbPanelWrapper;

public class JWrapCheckBox
implements MouseListener {
    private ColorPropagatingPanel rootComponent = new ColorPropagatingPanel();
    private JCheckBox checkBox = new JCheckBox();
    private JLabel label;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public JWrapCheckBox(String labelText) {
        this.label = labelText.toLowerCase().startsWith("<html") ? new JWrapLabel(labelText) : new JWrapLabel("<html>" + labelText + "</html>");
        GbPanelWrapper wrapper = new GbPanelWrapper(this.rootComponent);
        wrapper.add(this.checkBox, 0, 0, 1, 1, 0, 1, 17, 0);
        wrapper.add(this.label, 1, 0, 1, 1, 1, 1, 17, 1);
        this.label.addMouseListener(this);
    }

    public void setBackground(Color c) {
        this.rootComponent.setBackground(c);
        this.checkBox.setBackground(c);
    }

    public void setEnabled(boolean enabled) {
        this.checkBox.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public void addItemListener(ItemListener listener) {
        this.checkBox.addItemListener(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.checkBox.addActionListener(listener);
    }

    public JCheckBox getCheckBoxComponent() {
        return this.checkBox;
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public void setSelected(boolean b) {
        this.checkBox.setSelected(b);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() == 1) {
            this.checkBox.doClick();
            this.checkBox.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setVisible(boolean visible) {
        this.rootComponent.setVisible(visible);
    }
}

