/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import utils.swing.components.GradientPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.listeners.HandCursorMouseListener;

public class CleanTabbedPanel
implements MouseListener {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private CardLayout cl = new CardLayout();
    private JPanel contentPanel = new JPanel(this.cl);
    private JPanel buttonsPanel = new JPanel();
    private ArrayList buttonList = new ArrayList();
    private int selectedIndex = 0;
    private boolean enabled = true;
    private boolean top;
    private static final Border PADDING = SHBorderFactory.createEmptyBorder(3, 3, 3, 3);
    int offset = 0;
    ArrayList listeners = new ArrayList();

    public Border getBorder(boolean isSelected, boolean hasRight, boolean isTop) {
        int right = 0;
        int bottom = 0;
        if (hasRight) {
            right = 1;
        }
        if (!isSelected) {
            bottom = 1;
        }
        MatteBorder lineBorder = SHBorderFactory.createMatteBorder(0, 0, bottom, right, SHStyle.BORDER_COLOR);
        return SHBorderFactory.createCompoundBorder(lineBorder, PADDING);
    }

    public CleanTabbedPanel(boolean top) {
        this.top = top;
        this.initUI(top);
    }

    public JPanel getSelectedTab() {
        return (JPanel)this.contentPanel.getComponent(this.selectedIndex);
    }

    private void initUI(boolean top) {
        this.rootComponent.add((Component)this.contentPanel, "Center");
        if (top) {
            this.rootComponent.add((Component)this.buttonsPanel, "North");
        } else {
            this.rootComponent.add((Component)this.buttonsPanel, "South");
        }
        this.buttonsPanel.setVisible(false);
    }

    public void addTab(Icon icon, JComponent content) {
        GradientPanel buttonPanel;
        this.contentPanel.add((Component)content, this.buttonsPanel.getComponentCount() + "");
        JPanel previousPanel = null;
        if (this.buttonsPanel.getComponentCount() == 0) {
            buttonPanel = new GradientPanel(GradientPanel.NICE_BLUE_TOP_BOLD, GradientPanel.NICE_BLUE_BOTTOM_BOLD);
        } else {
            previousPanel = (JPanel)this.buttonsPanel.getComponent(this.buttonsPanel.getComponentCount() - 1);
            buttonPanel = new GradientPanel(GradientPanel.NICE_BLUE_TOP, GradientPanel.NICE_BLUE_BOTTOM);
        }
        if (previousPanel != null) {
            previousPanel.setBorder(this.getBorder(false, true, this.top));
        }
        buttonPanel.setBorder(PADDING);
        buttonPanel.setLayout(new GridLayout(1, 1));
        JLabel buttonIcon = new JLabel(icon);
        if (icon == null) {
            buttonIcon.setText(this.buttonsPanel.getComponentCount() + "");
        }
        buttonPanel.add(buttonIcon);
        buttonPanel.addMouseListener(HandCursorMouseListener.INSTANCE);
        buttonPanel.addMouseListener(this);
        this.buttonList.add(buttonPanel);
        this.buttonsPanel.add(buttonPanel);
        this.buttonsPanel.setLayout(new GridLayout(1, this.buttonsPanel.getComponentCount()));
        if (this.buttonsPanel.getComponentCount() > 1) {
            this.buttonsPanel.setVisible(true);
        }
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        GradientPanel sourcePanel = (GradientPanel)e.getSource();
        GradientPanel oldSelectedPanel = (GradientPanel)this.buttonList.get(this.selectedIndex);
        oldSelectedPanel.setTopColor(GradientPanel.NICE_BLUE_TOP);
        oldSelectedPanel.setBottomColor(GradientPanel.NICE_BLUE_BOTTOM);
        sourcePanel.setTopColor(GradientPanel.NICE_BLUE_TOP_BOLD);
        sourcePanel.setBottomColor(GradientPanel.NICE_BLUE_BOTTOM_BOLD);
        this.selectedIndex = this.buttonList.indexOf(sourcePanel);
        int oldSelectedIndex = this.buttonList.indexOf(oldSelectedPanel);
        sourcePanel.setBorder(this.getBorder(true, this.selectedIndex < this.buttonList.size() - 1, this.top));
        oldSelectedPanel.setBorder(this.getBorder(false, oldSelectedIndex < this.buttonList.size() - 1, this.top));
        this.cl.show(this.contentPanel, this.selectedIndex + "");
        this.rootComponent.repaint();
        this.notifyTabChange((JPanel)this.contentPanel.getComponent(this.selectedIndex));
    }

    public void addTabChangeListener(TabChangeListener listneer) {
        this.listeners.add(listneer);
    }

    private void notifyTabChange(JPanel contentPanel) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TabChangeListener)this.listeners.get(i)).notifyTabChange(contentPanel);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public int getTabCount() {
        return this.buttonsPanel.getComponentCount();
    }

    public void removeTab(int i) {
        this.buttonsPanel.remove(i);
        this.contentPanel.remove(i);
        if (this.buttonsPanel.getComponentCount() > 1) {
            this.buttonsPanel.setVisible(true);
        } else {
            this.buttonsPanel.setVisible(false);
        }
    }

    public void removeTab(JComponent c) {
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            if (!this.contentPanel.getComponent(i).equals(c)) continue;
            this.removeTab(i);
            return;
        }
    }

    public void setVisible(boolean b) {
        this.rootComponent.setVisible(b);
    }

    public boolean isVisible() {
        return this.rootComponent.isVisible();
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
        for (int i = 0; i < this.buttonsPanel.getComponentCount(); ++i) {
            GradientPanel panel = (GradientPanel)this.buttonsPanel.getComponent(i);
            panel.setEnabled(isEnabled);
            for (int j = 0; j < panel.getComponentCount(); ++j) {
                panel.getComponent(j).setEnabled(isEnabled);
            }
            boolean isSelected = i == this.selectedIndex;
            boolean hasRight = i < this.buttonsPanel.getComponentCount() - 1;
            panel.setBorder(this.getBorder(isSelected, hasRight, this.top));
            if (isSelected) {
                if (isEnabled) {
                    panel.setTopColor(GradientPanel.NICE_BLUE_TOP_BOLD);
                    panel.setBottomColor(GradientPanel.NICE_BLUE_BOTTOM_BOLD);
                    continue;
                }
                panel.setTopColor(GradientPanel.NICE_BLUE_TOP_BOLD_DISABLED);
                panel.setBottomColor(GradientPanel.NICE_BLUE_BOTTOM_BOLD_DISABLED);
                continue;
            }
            if (isEnabled) {
                panel.setTopColor(GradientPanel.NICE_BLUE_TOP);
                panel.setBottomColor(GradientPanel.NICE_BLUE_BOTTOM);
                continue;
            }
            panel.setTopColor(GradientPanel.NICE_BLUE_TOP_DISABLED);
            panel.setBottomColor(GradientPanel.NICE_BLUE_BOTTOM_DISABLED);
        }
    }

    public static void main(String[] args) {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
    }

    public static interface TabChangeListener {
        public void notifyTabChange(JPanel var1);
    }
}

