/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.color.colorpicker.ColorPicker;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jlist.SimpleListModel;
import utils.swing.simplelist.wrapper.SortWrapper;

public class ConfigurableColor {
    private static JFrame configUI = new SimpleHelpFrame();
    private static JPanel mainPanel = new JPanel(new GridLayout(2, 1));
    private static GbPanel configPanel = new GbPanel();
    private static ColorPicker cp = new ColorPicker();
    private static JList list = new JList();
    private static SimpleList<ColorWrapper> listModel = new SimpleList();
    private static SortWrapper wrapper = new SortWrapper<ColorWrapper>(listModel, SortWrapper.LEXICAL_COMPARATOR);
    private static SelectionListener selectionListener = new SelectionListener();
    private static ColorWrapper selectedValue;

    private static void initForColour(ColorWrapper selectedValue) {
        ConfigurableColor.selectedValue = selectedValue;
        cp.setColor(selectedValue.colour);
        cp.repaint();
        configPanel.repaint();
    }

    public ConfigurableColor(Color colour, String description, JComponent repaintComponent) {
        ColorWrapper wrapper = new ColorWrapper(colour, description, repaintComponent);
        listModel.add(wrapper);
    }

    public static void showConfigurationUI() {
        if (!configUI.isVisible()) {
            ConfigurableColor.initUI();
        }
    }

    private static void initUI() {
        list.setModel(new SimpleListModel<ColorWrapper>(listModel));
        list.addListSelectionListener(selectionListener);
        mainPanel.add(list);
        mainPanel.add(configPanel);
        configPanel.add(cp, 0, 0, 1, 1, 1, 1, 10, 1);
        cp.addPropertyChangeListener("selected color", selectionListener);
        configUI.getContentPane().add(mainPanel);
        configUI.setSize(300, 500);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        configUI.setLocation(size.width - configUI.getWidth(), 0);
        configUI.setVisible(true);
    }

    private class ColorWrapper {
        private JComponent repaintComponent;
        private String description;
        private Color colour;

        private ColorWrapper(Color colour, String description, JComponent repaintComponent) {
            this.colour = colour;
            this.description = description;
            this.repaintComponent = repaintComponent;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class SelectionListener
    extends KeyAdapter
    implements ListSelectionListener,
    ChangeListener,
    PropertyChangeListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ConfigurableColor.initForColour((ColorWrapper)list.getSelectedValue());
        }

        @Override
        public void keyReleased(KeyEvent k) {
        }

        private void setRGB(Color c) {
            try {
                cp.setColor(c);
                Field field = Color.class.getDeclaredField("value");
                field.setAccessible(true);
                field.set(selectedValue.colour, c.getRGB());
                selectedValue.repaintComponent.repaint();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Color c = cp.getColor();
            this.setRGB(c);
        }
    }
}

