/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.borders;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class SimpleShadowBorder
implements Border {
    private Color darkest = new Color(150, 150, 150);
    private Color darker = new Color(200, 200, 200);
    private Color normal = new Color(235, 235, 235);

    public SimpleShadowBorder(boolean useDarkColours) {
        if (useDarkColours) {
            int diff = 85;
            this.darkest = new Color(this.darkest.getRed() - diff, this.darkest.getBlue() - diff, this.darkest.getGreen() - diff);
            this.darker = new Color(this.darker.getRed() - diff, this.darker.getBlue() - diff, this.darker.getGreen() - diff);
            this.normal = new Color(this.normal.getRed() - diff, this.normal.getBlue() - diff, this.normal.getGreen() - diff);
        }
    }

    public SimpleShadowBorder() {
        this(false);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int arc = 4;
        g.setColor(this.darkest);
        g.drawRoundRect(x, y + 1, width - 1, height - 1, 0, 0);
        g.setColor(this.darker);
        g.drawRoundRect(x - 1, y - 1, width + 1, height + 2, arc, arc);
        g.setColor(this.normal);
        g.drawRoundRect(x - 2, y - 1, width + 3, height + 3, arc + 3, arc + 3);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 2, 3, 2);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

