/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.borders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.Border;

public class RoundRectBorder
implements Border {
    protected Color color;
    protected int radius;
    protected int padding = 3;
    protected Stroke stroke = new BasicStroke(1.0f);
    private Color fillColor = null;

    public RoundRectBorder(Color color, int radius) {
        this.color = color;
        this.radius = radius;
    }

    public RoundRectBorder(Color color, int radius, int padding) {
        this(color, radius);
        this.padding = padding;
    }

    public RoundRectBorder(Color color, int radius, int padding, Color fillColor) {
        this(color, radius);
        this.padding = padding;
        this.fillColor = fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setWidth(float width) {
        this.stroke = new BasicStroke(width);
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        int value = this.radius / 2 + this.padding;
        return new Insets(value, value, value, value);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        Insets insets = this.getBorderInsets(comp);
        int arc = this.radius * 2;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.stroke != null) {
            g2.setStroke(this.stroke);
        }
        if (this.fillColor != null) {
            g.setColor(this.fillColor);
            g.fillRoundRect(x, y, width - 1, height - 1, arc, arc);
        }
        g.setColor(this.color);
        g.drawRoundRect(x, y, width - 1, height - 1, arc, arc);
    }
}

