/*
 * Decompiled with CFR 0.152.
 */
package utils.string;

import java.util.Arrays;
import java.util.Random;

public class WebBase64 {
    private static final char nonAlphabet1 = '+';
    private static final char nonAlphabet2 = '/';
    private static final char specialchar = '=';
    private static final String specialchar2 = "==";
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static byte[] base64ToInt = new byte[255];

    public static String pngToHtmlImgSrcTagContents(byte[] png) {
        return "data:image/png;base64," + WebBase64.byteArrayToBase64(png);
    }

    public static String byteArrayToBase64(byte[] a) {
        return WebBase64.byteArrayToBase64SB(a).toString();
    }

    public static StringBuffer byteArrayToBase64SB(byte[] a) {
        int aLen = a.length;
        int numFullGroups = aLen / 3;
        int numBytesInPartialGroup = aLen - 3 * numFullGroups;
        int resultLen = 4 * ((aLen + 2) / 3);
        StringBuffer result = new StringBuffer(resultLen);
        char[] intToAlpha = intToBase64;
        int inCursor = 0;
        for (int i = 0; i < numFullGroups; ++i) {
            int byte0 = a[inCursor++] & 0xFF;
            int byte1 = a[inCursor++] & 0xFF;
            int byte2 = a[inCursor++] & 0xFF;
            result.append(intToAlpha[byte0 >> 2]);
            result.append(intToAlpha[byte0 << 4 & 0x3F | byte1 >> 4]);
            result.append(intToAlpha[byte1 << 2 & 0x3F | byte2 >> 6]);
            result.append(intToAlpha[byte2 & 0x3F]);
        }
        if (numBytesInPartialGroup != 0) {
            int byte0 = a[inCursor++] & 0xFF;
            result.append(intToAlpha[byte0 >> 2]);
            if (numBytesInPartialGroup == 1) {
                result.append(intToAlpha[byte0 << 4 & 0x3F]);
                result.append(specialchar2);
            } else {
                int byte1 = a[inCursor++] & 0xFF;
                result.append(intToAlpha[byte0 << 4 & 0x3F | byte1 >> 4]);
                result.append(intToAlpha[byte1 << 2 & 0x3F]);
                result.append('=');
            }
        }
        return result;
    }

    public static byte[] base64ToByteArray(String s) {
        byte[] alphaToInt = base64ToInt;
        int sLen = s.length();
        int numGroups = sLen / 4;
        if (4 * numGroups != sLen) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int missingBytesInLastGroup = 0;
        int numFullGroups = numGroups;
        if (sLen != 0) {
            if (s.charAt(sLen - 1) == '=') {
                ++missingBytesInLastGroup;
                --numFullGroups;
            }
            if (s.charAt(sLen - 2) == '=') {
                ++missingBytesInLastGroup;
            }
        }
        byte[] result = new byte[3 * numGroups - missingBytesInLastGroup];
        int inCursor = 0;
        int outCursor = 0;
        for (int i = 0; i < numFullGroups; ++i) {
            int ch0 = WebBase64.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch1 = WebBase64.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch2 = WebBase64.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch3 = WebBase64.base64toInt(s.charAt(inCursor++), alphaToInt);
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            result[outCursor++] = (byte)(ch2 << 6 | ch3);
        }
        if (missingBytesInLastGroup != 0) {
            int ch0 = WebBase64.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch1 = WebBase64.base64toInt(s.charAt(inCursor++), alphaToInt);
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            if (missingBytesInLastGroup == 1) {
                int ch2 = WebBase64.base64toInt(s.charAt(inCursor++), alphaToInt);
                result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            }
        }
        return result;
    }

    private static int base64toInt(char c, byte[] alphaToInt) {
        byte result = alphaToInt[c];
        if (result < 0) {
            throw new IllegalArgumentException("Illegal character " + c + " (" + c + ")");
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        System.out.println(WebBase64.byteArrayToBase64("Aladdin:open sesame".getBytes("UTF8")));
        System.exit(0);
        int numRuns = 1;
        int numBytes = 20;
        Random rnd = new Random();
        for (int i = 0; i < numRuns; ++i) {
            int j = numBytes;
            byte[] arr = new byte[j];
            for (int k = 0; k < j; ++k) {
                arr[k] = (byte)rnd.nextInt();
            }
            String s = WebBase64.byteArrayToBase64(arr);
            byte[] b = WebBase64.base64ToByteArray(s);
            if (!Arrays.equals(arr, b)) {
                System.out.println("Dismal failure!");
            }
            System.out.println(s);
        }
    }

    static {
        Arrays.fill(base64ToInt, (byte)-1);
        for (int i = 0; i < intToBase64.length; ++i) {
            WebBase64.base64ToInt[WebBase64.intToBase64[i]] = (byte)i;
        }
    }
}

