/*
 * Decompiled with CFR 0.152.
 */
package utils.string;

import java.util.ArrayList;

public class Chunker {
    public static String escapeSpaces(String s) {
        char[] cs = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (char c : cs) {
            if (c == ' ') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static ArrayList<String> chunk(String source, boolean spacesMayBeEscaped) {
        return Chunker.chunk(source, spacesMayBeEscaped, false);
    }

    public static ArrayList<String> chunk(String source, boolean spacesMayBeEscaped, boolean trimAll) {
        ArrayList<String> list = new ArrayList<String>();
        char[] cs = source.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean inQuote = false;
        int quoteChar = 32;
        int prevChar = 32;
        for (int n : cs) {
            if (!inQuote && n == 32 && spacesMayBeEscaped && prevChar == 92) {
                sb.setCharAt(sb.length() - 1, ' ');
            } else if (!inQuote && n == 32) {
                if (sb.length() > 0) {
                    list.add(trimAll ? sb.toString().trim() : sb.toString());
                    sb.setLength(0);
                }
            } else if (inQuote && n == quoteChar) {
                inQuote = false;
                if (sb.length() > 0) {
                    list.add(trimAll ? sb.toString().trim() : sb.toString());
                    sb.setLength(0);
                }
            } else if (n == 39) {
                if (!inQuote) {
                    inQuote = true;
                    quoteChar = 39;
                }
            } else if (n == 34) {
                if (!inQuote) {
                    inQuote = true;
                    quoteChar = 34;
                }
            } else {
                sb.append((char)n);
            }
            prevChar = n;
        }
        list.add(trimAll ? sb.toString().trim() : sb.toString());
        return list;
    }

    private static void print(ArrayList<String> list) {
        System.out.println("List...");
        for (String chunk : list) {
            System.out.println("Chunk: " + chunk);
        }
    }

    public static void main(String[] args) throws Exception {
        Chunker.print(Chunker.chunk("one two three", false));
        Chunker.print(Chunker.chunk("one\\ two\\ three", false));
        Chunker.print(Chunker.chunk("one\\ two\\ three", true));
        Chunker.print(Chunker.chunk("one  \"two three\"", true));
        Chunker.print(Chunker.chunk("one  'two three'", true));
    }
}

