/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import utils.progtools.net.URLParser;
import utils.stream.StreamUtils;

public class UrlFetch {
    public static void main(String[] args) {
        System.out.println(UrlFetch.buildUrlFrom("http://ops.simplehelp.io:8008/moonpig", "/allversions"));
        System.out.println(UrlFetch.buildUrlFrom("https://ops.simplehelp.io:8008/moonpig", "/allversions"));
        System.out.println(UrlFetch.buildUrlFrom("https://ops.simplehelp.io/moonpig?x=1&y=2", "/allversions"));
        System.out.println(UrlFetch.buildUrlFrom("http://ops.simplehelp.io/moonpig?dhkasdhksahdkjsa222=2333", "/allversions"));
        System.out.println(UrlFetch.buildUrlFrom("udp://ops.simplehelp.io/moonpig", "/allversions"));
    }

    public static URL buildUrlFrom(String serverurl, String newpath) {
        try {
            int port;
            URLParser parser = new URLParser(serverurl);
            String host = parser.getHostname();
            String protocol = parser.getProtocol(true);
            if (!protocol.equalsIgnoreCase("https")) {
                protocol = "http";
            }
            if ((port = parser.getPort(false)) == -1) {
                port = protocol.equalsIgnoreCase("https") ? 443 : 80;
            }
            if (!newpath.startsWith("/")) {
                newpath = "/" + newpath;
            }
            return new URL(protocol + "://" + host + ":" + port + newpath);
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String grabAsUTF8(URL url) {
        String string;
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        try {
            String utf8;
            string = utf8 = StreamUtils.readAllAsStringUTF8(in);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (Throwable t) {
                return null;
            }
        }
        ((InputStream)in).close();
        return string;
    }
}

