/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import utils.stream.OpenByteArrayOutputStream;

public class StreamReader
extends Thread {
    OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();
    InputStream in;
    boolean discard;

    public void clear() {
        this.bout.reset();
    }

    public StreamReader(InputStream in, boolean discard) {
        this.in = new BufferedInputStream(in);
        this.discard = discard;
        this.setDaemon(true);
        this.start();
    }

    public String getAsString() {
        try {
            return new String(this.bout.getByteArray(), 0, this.bout.size(), "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return "Unsupported ASCII encoding??";
        }
    }

    @Override
    public void run() {
        try {
            int n = 0;
            byte[] buf = new byte[1024];
            while (n != -1) {
                n = this.in.read(buf, 0, buf.length);
                if (this.discard || n <= 0) continue;
                this.bout.write(buf, 0, n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

