/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import utils.stream.OpenByteArrayOutputStream;

public class CFriendlyStreamUtils {
    public static void writeString(OutputStream out, String s) throws IOException {
        byte[] dat;
        for (byte aDat : dat = s.getBytes("ASCII")) {
            if (aDat != 0) continue;
            throw new IOException("ERROR: NUL character not allowed in CFriendly strings!");
        }
        out.write(dat);
        out.write(0);
    }

    public static void writeLong(OutputStream out, long x) throws IOException {
        String s = Long.toString(x);
        CFriendlyStreamUtils.writeString(out, s);
    }

    public static void writeInt(OutputStream out, int x) throws IOException {
        CFriendlyStreamUtils.writeLong(out, (long)x);
    }

    public static void writeBoolean(OutputStream out, boolean x) throws IOException {
        if (x) {
            CFriendlyStreamUtils.writeLong(out, 1L);
        } else {
            CFriendlyStreamUtils.writeLong(out, 0L);
        }
    }

    public static void writeString(RandomAccessFile out, String s) throws IOException {
        byte[] dat;
        for (byte aDat : dat = s.getBytes("ASCII")) {
            if (aDat != 0) continue;
            throw new IOException("ERROR: NUL character not allowed in CFriendly strings!");
        }
        out.write(dat);
        out.write(0);
    }

    public static void writeLong(RandomAccessFile out, long x) throws IOException {
        String s = Long.toString(x);
        CFriendlyStreamUtils.writeString(out, s);
    }

    public static void writeInt(RandomAccessFile out, int x) throws IOException {
        CFriendlyStreamUtils.writeLong(out, (long)x);
    }

    public static void writeBoolean(RandomAccessFile out, boolean x) throws IOException {
        if (x) {
            CFriendlyStreamUtils.writeLong(out, 1L);
        } else {
            CFriendlyStreamUtils.writeLong(out, 0L);
        }
    }

    public static String readString(InputStream in) throws IOException {
        return CFriendlyStreamUtils.readString(in, null);
    }

    public static String readString(InputStream in, ReadCache readCache) throws IOException {
        StringBuilder sb = new StringBuilder();
        int n = in.read();
        if (n == -1) {
            throw new EOFException("stream finished");
        }
        if (readCache != null) {
            readCache.add(n);
        }
        while (n != 0 && n != -1) {
            sb.append((char)n);
            n = in.read();
            if (readCache == null || n == -1) continue;
            readCache.add(n);
        }
        return sb.toString();
    }

    public static long readLong(InputStream in) throws IOException {
        return CFriendlyStreamUtils.readLong(in, null);
    }

    public static long readLong(InputStream in, ReadCache readCache) throws IOException {
        return Long.parseLong(CFriendlyStreamUtils.readString(in, readCache));
    }

    public static int readInt(InputStream in) throws IOException {
        return CFriendlyStreamUtils.readInt(in, null);
    }

    public static int readInt(InputStream in, ReadCache readCache) throws IOException {
        return Integer.parseInt(CFriendlyStreamUtils.readString(in, readCache));
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        return CFriendlyStreamUtils.readBoolean(in, null);
    }

    public static boolean readBoolean(InputStream in, ReadCache readCache) throws IOException {
        return CFriendlyStreamUtils.readInt(in, readCache) == 1;
    }

    public static String readString(RandomAccessFile in) throws IOException {
        return CFriendlyStreamUtils.readString(in, null);
    }

    public static String readString(RandomAccessFile in, ReadCache readCache) throws IOException {
        StringBuilder sb = new StringBuilder();
        int n = in.read();
        if (n == -1) {
            throw new EOFException("stream finished");
        }
        if (readCache != null) {
            readCache.add(n);
        }
        while (n != 0 && n != -1) {
            sb.append((char)n);
            n = in.read();
            if (readCache == null || n == -1) continue;
            readCache.add(n);
        }
        return sb.toString();
    }

    public static long readLong(RandomAccessFile in) throws IOException {
        return CFriendlyStreamUtils.readLong(in, null);
    }

    public static long readLong(RandomAccessFile in, ReadCache readCache) throws IOException {
        return Long.parseLong(CFriendlyStreamUtils.readString(in, readCache));
    }

    public static int readInt(RandomAccessFile in) throws IOException {
        return CFriendlyStreamUtils.readInt(in, null);
    }

    public static int readInt(RandomAccessFile in, ReadCache readCache) throws IOException {
        return Integer.parseInt(CFriendlyStreamUtils.readString(in, readCache));
    }

    public static boolean readBoolean(RandomAccessFile in) throws IOException {
        return CFriendlyStreamUtils.readBoolean(in, null);
    }

    public static boolean readBoolean(RandomAccessFile in, ReadCache readCache) throws IOException {
        return CFriendlyStreamUtils.readInt(in, readCache) == 1;
    }

    public static class ReadCache {
        private OpenByteArrayOutputStream cache = new OpenByteArrayOutputStream();

        public void add(int b) {
            this.cache.write(b);
        }

        public void clear() {
            this.cache.reset();
        }

        public int getLength() {
            return this.cache.size();
        }

        public byte[] getByteArray() {
            return this.cache.getByteArray();
        }
    }
}

