/*
 * Decompiled with CFR 0.152.
 */
package utils.ssl.sslmanager.signingtools;

import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import utils.ssl.sslmanager.signingtools.SHTrustManager;

public class SHTrustProvider
extends Provider {
    private static final String TRUST_PROVIDER_ALG = "SHTrustProviderAlgorithm";
    private static final String TRUST_PROVIDER_ID = "SHTrustProvider";

    public static void register() {
        Provider registered = Security.getProvider(TRUST_PROVIDER_ID);
        if (null == registered) {
            Security.insertProviderAt(new SHTrustProvider(), 1);
            Security.setProperty("ssl.TrustManagerFactory.algorithm", TRUST_PROVIDER_ALG);
        }
    }

    private SHTrustProvider() {
        super(TRUST_PROVIDER_ID, 1.0, "SHTrustProvider to trust SH-specific root certs as well as the ones in cacerts");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SHTrustProvider.this.put("TrustManagerFactory." + SHTrustManagerFactory.getAlgorithm(), SHTrustManagerFactory.class.getName());
                return null;
            }
        });
    }

    public static final class SHTrustManagerFactory
    extends TrustManagerFactorySpi {
        @Override
        protected void engineInit(ManagerFactoryParameters mgrparams) {
        }

        @Override
        protected void engineInit(KeyStore keystore) {
        }

        @Override
        protected TrustManager[] engineGetTrustManagers() {
            return new TrustManager[]{SHTrustManager.INSTANCE};
        }

        public static String getAlgorithm() {
            return SHTrustProvider.TRUST_PROVIDER_ALG;
        }
    }
}

