/*
 * Decompiled with CFR 0.152.
 */
package utils.ssl.sslmanager.signingtools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;

public class ExtendableKeystore {
    private final KeyStore keyStore;
    private final File keystoreFile;
    private final String keystorePassword;
    private final Random r = new Random(System.currentTimeMillis());

    public ExtendableKeystore(File keystoreFile, String keystorePassword) throws CertificateException, IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        this.keystoreFile = keystoreFile;
        this.keystorePassword = keystorePassword;
        if (keystoreFile.exists() && keystoreFile.length() > 0L) {
            this.keyStore = ExtendableKeystore.openKeystore(keystoreFile, keystorePassword);
        } else {
            if (keystoreFile.exists()) {
                keystoreFile.delete();
            }
            this.keyStore = KeyStore.getInstance("JKS");
            this.keyStore.load(null, keystorePassword.toCharArray());
            this.saveKeystore();
        }
    }

    public X509Certificate[] getAllCertificates() throws KeyStoreException {
        ArrayList<X509Certificate> allCertificates = new ArrayList<X509Certificate>();
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate certificate = (X509Certificate)this.keyStore.getCertificate(alias);
            allCertificates.add(certificate);
        }
        return allCertificates.toArray(new X509Certificate[0]);
    }

    public void addCertificate(X509Certificate cert) throws Exception {
        String alias;
        if (this.keyStore.getCertificateAlias(cert) != null) {
            return;
        }
        System.out.println("[ExtendableKeystore] Adding certificate " + cert.getSubjectDN());
        while (this.keyStore.containsAlias(alias = "simplehelp-imported-" + this.r.nextInt(1000))) {
        }
        this.keyStore.setCertificateEntry(alias, cert);
        this.saveKeystore();
    }

    public void deleteCertificate(X509Certificate cert) throws Exception {
        System.out.println("[ExtendableKeystore] Removing certificate " + cert.getSubjectDN());
        String alias = this.keyStore.getCertificateAlias(cert);
        if (alias != null) {
            this.deleteCertificate(alias);
        }
    }

    private void saveKeystore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        System.out.println("[ExtendableKeystore] Saving.");
        try (FileOutputStream fout = new FileOutputStream(this.keystoreFile);){
            this.keyStore.store(fout, this.keystorePassword.toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore openKeystore(File file, String storePassword) throws CertificateException, UnrecoverableKeyException, IOException {
        System.out.println("[ExtendableKeystore] Attempting to load keystore as JKS");
        KeyStore keyStore = null;
        try {
            try {
                keyStore = KeyStore.getInstance("JKS");
                try (FileInputStream fin = new FileInputStream(file);){
                    keyStore.load(fin, storePassword.toCharArray());
                }
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        catch (IOException badFormatException) {
            if (badFormatException.getCause() != null && badFormatException.getCause() instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)badFormatException.getCause();
            }
            if (badFormatException.getMessage() != null && !badFormatException.getMessage().equals("Invalid keystore format")) {
                badFormatException.printStackTrace();
            }
            try {
                System.out.println("[ExtendableKeystore] Opening as a JKS failed. Attempting PKCS12");
                try {
                    keyStore = KeyStore.getInstance("PKCS12");
                    keyStore.load(new FileInputStream(file), storePassword.toCharArray());
                }
                catch (KeyStoreException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException t) {
                t.printStackTrace();
                if (t.getCause() != null && t.getCause() instanceof UnrecoverableKeyException) {
                    throw (UnrecoverableKeyException)t.getCause();
                }
                throw badFormatException;
            }
        }
        return keyStore;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void deleteCertificate(String alias) throws Exception {
        this.keyStore.deleteEntry(alias);
        this.saveKeystore();
    }

    public void deleteCertificateBySerial(String serial) throws Exception {
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
            if (!cert.getSerialNumber().toString().equals(serial)) continue;
            this.keyStore.deleteEntry(alias);
            this.saveKeystore();
            return;
        }
    }
}

