/*
 * Decompiled with CFR 0.152.
 */
package utils.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import utils.ssh.CustomUserInfo;
import utils.ssh.SSHResponse;
import utils.stream.StreamPiper;

public class SSHClient {
    public static int TIMEOUT = -1;
    private static final String FROM = "SShClient";
    private Session session;
    boolean DEBUG = false;
    public static boolean VERBOSE = true;
    private String host;
    private int port;
    private String username;
    private String password;
    private File rsaID;
    private String rsaPhrase;
    private int localPort;
    private int remotePort;
    private static boolean printCommands = false;
    private static boolean printActivity = true;
    boolean amRoot = false;
    long maxwait = 30000L;

    public static void setPrintCommands(boolean b) {
        printCommands = b;
    }

    public static void setPrintActivity(boolean b) {
        printActivity = b;
    }

    public SSHClient cloneClient() {
        try {
            SSHClient client = this.rsaID != null ? new SSHClient(this.host, this.port, this.username, this.rsaID, this.rsaPhrase) : new SSHClient(this.host, this.port, this.username, this.password);
            if (this.amRoot) {
                client.setAmRoot(true);
            }
            return client;
        }
        catch (Exception x) {
            return null;
        }
    }

    public void setAmRoot(boolean amRoot) {
        this.amRoot = amRoot;
    }

    public SSHClient(String host, int port, String username, File rsaID, String rsaPhrase) throws JSchException {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = null;
        this.rsaID = rsaID;
        this.rsaPhrase = rsaPhrase;
        this.localPort = -1;
        this.remotePort = -1;
        this.reinitSession();
    }

    public SSHClient(String host, int port, String username, String password) throws JSchException {
        this(host, port, username, password, -1, -1);
    }

    public SSHClient(String host, int port, String username, String password, int localFwdPort, int remoteFwdPort) throws JSchException {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.localPort = localFwdPort;
        this.remotePort = remoteFwdPort;
        this.reinitSession();
    }

    public void reinitSession() throws JSchException {
        int MAX_CONNECTS = 5;
        for (int A = 1; A <= MAX_CONNECTS; ++A) {
            try {
                if (VERBOSE) {
                    System.out.println("[SSHClient] Establishing session (attempt " + A + ")");
                }
                if (this.session != null) {
                    if (VERBOSE) {
                        System.out.println("[SSHClient] Disconnecting existing...");
                    }
                    this.session.disconnect();
                }
                JSch jsch = new JSch();
                if (this.rsaID != null) {
                    if (this.rsaPhrase != null) {
                        if (VERBOSE) {
                            System.out.println("[SSHClient] Using RSA ID " + this.rsaID + " (with phrase)");
                        }
                        jsch.addIdentity(this.rsaID.getAbsolutePath(), this.rsaPhrase);
                    } else {
                        if (VERBOSE) {
                            System.out.println("[SSHClient] Using RSA ID " + this.rsaID + " (no phrase)");
                        }
                        jsch.addIdentity(this.rsaID.getAbsolutePath());
                    }
                }
                if (VERBOSE) {
                    System.out.println("[SSHClient] Opening session");
                }
                this.session = jsch.getSession(this.username, this.host, this.port);
                if (this.localPort != -1 && this.remotePort != -1) {
                    this.session.setPortForwardingL(this.localPort, this.host, this.remotePort);
                }
                if (TIMEOUT != -1) {
                    this.session.setTimeout(TIMEOUT);
                }
                this.session.setUserInfo((UserInfo)new CustomUserInfo(this.username, this.password));
                if (this.rsaID == null) {
                    this.session.setPassword(this.password);
                }
                this.session.connect();
                if (!VERBOSE) break;
                System.out.println("[SSHClient] Session connected OK");
                break;
            }
            catch (JSchException x) {
                if (A != MAX_CONNECTS) continue;
                throw x;
            }
        }
    }

    public static SSHClient newSShClient(String host, int port, String username, String password, int localPort, int remotePort) throws JSchException {
        SSHClient client = new SSHClient(host, port, username, password, localPort, remotePort);
        return client;
    }

    public static SSHClient newSShClient(String host, int port, String username, String password) throws JSchException {
        SSHClient client = new SSHClient(host, port, username, password, -1, -1);
        return client;
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public void handleInitialPasswordChange(String currentPasswd, String newPaswd) throws JSchException, IOException {
        Channel channel = this.session.openChannel("exec");
        ChannelExec exec = (ChannelExec)channel;
        exec.setPty(true);
        exec.setPtyType("vt100");
        exec.connect();
        ByteArrayOutputStream bstd = new ByteArrayOutputStream();
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        InputStream in = channel.getInputStream();
        OutputStream out = channel.getOutputStream();
        InputStream err = channel.getExtInputStream();
        Thread stdThread = StreamPiper.pipeAsync(in, System.out, 40000);
        Thread errThread = StreamPiper.pipeAsync(err, System.err, 40000);
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String current = currentPasswd;
        String nextpass = newPaswd;
        out.write(current.getBytes());
        out.write(10);
        out.flush();
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        out.write(nextpass.getBytes());
        out.write(10);
        out.flush();
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        out.write(nextpass.getBytes());
        out.write(10);
        out.flush();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        exec.disconnect();
    }

    public void scpFile(String localFile, String remoteFile) throws JSchException {
        this.scpFile(localFile, remoteFile, 1);
    }

    private void scpFile(String localFile, String remoteFile, int attempt) throws JSchException {
        if (VERBOSE) {
            System.out.println("Attempting to ScpFile " + localFile + " to " + remoteFile);
        }
        FileInputStream fis = null;
        try {
            int len;
            String command = "scp -p -t " + remoteFile;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            try {
                channel.connect();
            }
            catch (JSchException ex) {
                if (ex.getMessage().indexOf("session is down") != -1) {
                    this.reinitSession();
                    channel = this.session.openChannel("exec");
                    ((ChannelExec)channel).setCommand(command);
                    out = channel.getOutputStream();
                    in = channel.getInputStream();
                    channel.connect();
                }
                throw ex;
            }
            if (SSHClient.checkAck(in) != 0) {
                throw new JSchException("Invalid ACK received : check 0");
            }
            long filesize = new File(localFile).length();
            command = "C0644 " + filesize + " ";
            command = localFile.lastIndexOf(47) > 0 ? command + localFile.substring(localFile.lastIndexOf(47) + 1) : command + localFile;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            if (SSHClient.checkAck(in) != 0) {
                throw new JSchException("Invalid ACK received : check 1");
            }
            fis = new FileInputStream(localFile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
                out.flush();
            }
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (SSHClient.checkAck(in) != 0) {
                throw new JSchException("Invalid ACK received : check 2");
            }
            channel.disconnect();
        }
        catch (JSchException ex) {
            if (attempt == 3) {
                if (VERBOSE) {
                    System.out.println("[SSHClient] SCP failed again, giving up");
                }
                return;
            }
            if (ex.getMessage().indexOf("session is down") != -1) {
                if (VERBOSE) {
                    System.out.println("[SSHClient] Failed at open channel, reiniting and retrying...");
                }
                try {
                    this.reinitSession();
                    this.scpFile(localFile, remoteFile, attempt++);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            JSchException ex = new JSchException();
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public boolean scpFrom(String remoteFile, String toLocalFile) {
        return this.scpFrom(remoteFile, toLocalFile, 1);
    }

    private boolean scpFrom(String remoteFile, String toLocalFile, int attempt) {
        FileOutputStream fos = null;
        try {
            int c;
            String command = "scp -f " + remoteFile;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = SSHClient.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                fos = new FileOutputStream(toLocalFile);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                if (SSHClient.checkAck(in) != 0) {
                    System.exit(0);
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
            this.session.disconnect();
            return true;
        }
        catch (JSchException ex) {
            if (attempt == 3) {
                if (VERBOSE) {
                    System.out.println("[SSHClient] SCP failed again, giving up");
                }
                return false;
            }
            if (ex.getMessage().indexOf("session is down") != -1) {
                if (VERBOSE) {
                    System.out.println("[SSHClient] Failed at open channel, reiniting and retrying...");
                }
                try {
                    this.reinitSession();
                    return this.scpFrom(remoteFile, toLocalFile, attempt++);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("[SSHClient] Exception: " + e);
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                throw new IOException("SShClient - checkAck() returned an error response: 1");
            }
            if (b == 2) {
                throw new IOException("SShClient - checkAck() returned an error response: 2");
            }
        }
        return b;
    }

    public void startCommand(String command) throws JSchException {
        if (VERBOSE) {
            System.out.println("Attempting to start SSh command.");
        }
        Channel channel = this.session.openChannel("exec");
        ((ChannelExec)channel).setCommand(command);
        channel.connect();
        channel.disconnect();
    }

    public void setMaxWait(long t) {
        this.maxwait = t;
    }

    public void resetMaxWait() {
        this.maxwait = 30000L;
    }

    public SSHResponse execSudoCommand(String cd, String command, String sudopass) throws JSchException, IOException {
        Channel channel;
        if (this.amRoot) {
            return this.execCommand(cd, command);
        }
        if (printCommands) {
            System.out.println("[SSHClient] Attempting to execute sudoed SSh command [" + command + "]");
        } else {
            System.out.println("[SSHClient] Attempting to execute sudoed SSh command.");
        }
        try {
            if (this.DEBUG) {
                System.out.println("[SSHClient] Opening exec channel (attempt 1)");
            }
            channel = this.session.openChannel("exec");
            if (this.DEBUG) {
                System.out.println("[SSHClient] Opening initial exec channel OK");
            }
        }
        catch (JSchException ex) {
            if (ex.getMessage().indexOf("session is down") != -1) {
                System.out.println("[SSHClient] Failed at open channel, reiniting and retrying...");
                this.reinitSession();
                return this.execSudoCommand(cd, command, sudopass);
            }
            throw ex;
        }
        if (cd != null) {
            ((ChannelExec)channel).setCommand("cd " + cd + "; sudo -S -p '' " + command);
        } else {
            ((ChannelExec)channel).setCommand("sudo -S -p '' " + command);
        }
        ByteArrayOutputStream bstd = new ByteArrayOutputStream();
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        InputStream in = channel.getInputStream();
        OutputStream out = channel.getOutputStream();
        InputStream err = channel.getExtInputStream();
        Thread stdThread = StreamPiper.pipeAsync(in, bstd, 40000);
        Thread errThread = StreamPiper.pipeAsync(err, berr, 40000);
        try {
            if (this.DEBUG) {
                System.out.println("[SSHClient] Connecting channel for exec");
            }
            channel.connect();
            if (this.DEBUG) {
                System.out.println("[SSHClient] Connected for exec");
            }
            out.write((sudopass + "\n").getBytes());
            out.flush();
            if (this.DEBUG) {
                System.out.println("[SSHClient] Wrote command");
            }
        }
        catch (JSchException ex) {
            if (ex.getMessage().indexOf("session is down") != -1) {
                if (VERBOSE) {
                    System.out.println("[SSHClient] Failed at channel connect, reiniting and retrying...");
                }
                this.reinitSession();
                return this.execSudoCommand(cd, command, sudopass);
            }
            throw ex;
        }
        SSHResponse sshResponse = new SSHResponse();
        try {
            if (this.maxwait == 0L) {
                if (printActivity) {
                    System.out.println("[SSHClient] Joining stdout, stderr (no timeout)");
                }
                stdThread.join(0L);
                errThread.join(0L);
                if (printActivity) {
                    System.out.println("[SSHClient] Joined output threads");
                }
            } else {
                long latest = System.currentTimeMillis() + this.maxwait;
                if (printActivity) {
                    System.out.println("[SSHClient] Joining stdout (" + this.maxwait + ")");
                }
                long time = latest - System.currentTimeMillis();
                stdThread.join(Math.max(10L, time));
                if (printActivity) {
                    System.out.println("[SSHClient] Joining stderr (" + this.maxwait + ")");
                }
                time = latest - System.currentTimeMillis();
                errThread.join(Math.max(10L, time));
                if (printActivity) {
                    System.out.println("[SSHClient] Joined output threads");
                }
            }
        }
        catch (Exception latest) {
            // empty catch block
        }
        sshResponse.wasSudo = true;
        sshResponse.origCommand = command;
        sshResponse.response = new String(bstd.toByteArray());
        sshResponse.error = new String(berr.toByteArray());
        sshResponse.exitCode = channel.getExitStatus();
        if (channel.isClosed() && printActivity) {
            System.out.println("Channel is closed with exit status:" + channel.getExitStatus());
        }
        channel.disconnect();
        try {
            ((PipedInputStream)in).close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            ((PipedInputStream)err).close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return sshResponse;
    }

    public SSHResponse execCommand(String cd, String command) throws JSchException, IOException {
        Channel channel;
        if (printCommands) {
            if (VERBOSE) {
                System.out.println("[SSHClient] Attempting to execute SSh command [" + command + "]");
            }
        } else if (printActivity && VERBOSE) {
            System.out.println("[SSHClient] Attempting to execute SSh command.");
        }
        try {
            if (this.DEBUG) {
                System.out.println("[SSHClient] Opening exec channel (attempt 1)");
            }
            channel = this.session.openChannel("exec");
            if (this.DEBUG) {
                System.out.println("[SSHClient] Opening initial exec channel OK");
            }
        }
        catch (JSchException ex) {
            if (ex.getMessage().indexOf("session is down") != -1) {
                System.out.println("[SSHClient] Failed at open channel, reiniting and retrying...");
                this.reinitSession();
                return this.execCommand(cd, command);
            }
            throw ex;
        }
        if (cd != null) {
            ((ChannelExec)channel).setCommand("cd " + cd + "; " + command);
        } else {
            ((ChannelExec)channel).setCommand(command);
        }
        ByteArrayOutputStream bstd = new ByteArrayOutputStream();
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        InputStream in = channel.getInputStream();
        OutputStream out = channel.getOutputStream();
        InputStream err = channel.getExtInputStream();
        Thread stdThread = StreamPiper.pipeAsync(in, bstd, 40000);
        Thread errThread = StreamPiper.pipeAsync(err, berr, 40000);
        try {
            if (this.DEBUG) {
                System.out.println("[SSHClient] Connecting channel for exec");
            }
            channel.connect();
            if (this.DEBUG) {
                System.out.println("[SSHClient] Connected for exec");
            }
            if (this.DEBUG) {
                System.out.println("[SSHClient] Wrote command");
            }
        }
        catch (JSchException ex) {
            if (ex.getMessage().indexOf("session is down") != -1) {
                if (VERBOSE) {
                    System.out.println("[SSHClient] Failed at channel connect, reiniting and retrying...");
                }
                this.reinitSession();
                return this.execCommand(cd, command);
            }
            throw ex;
        }
        SSHResponse sshResponse = new SSHResponse();
        try {
            if (this.maxwait == 0L) {
                if (printActivity) {
                    System.out.println("[SSHClient] Joining stdout, stderr (no timeout)");
                }
                stdThread.join(0L);
                errThread.join(0L);
                if (printActivity) {
                    System.out.println("[SSHClient] Joined output threads");
                }
            } else {
                long latest = System.currentTimeMillis() + this.maxwait;
                if (printActivity) {
                    System.out.println("[SSHClient] Joining stdout");
                }
                long time = latest - System.currentTimeMillis();
                stdThread.join(Math.max(10L, time));
                if (printActivity) {
                    System.out.println("[SSHClient] Joining stderr");
                }
                time = latest - System.currentTimeMillis();
                errThread.join(Math.max(10L, time));
                if (printActivity) {
                    System.out.println("[SSHClient] Joined output threads");
                }
            }
        }
        catch (Exception latest) {
            // empty catch block
        }
        sshResponse.wasSudo = false;
        sshResponse.origCommand = command;
        sshResponse.response = new String(bstd.toByteArray());
        sshResponse.error = new String(berr.toByteArray());
        sshResponse.exitCode = channel.getExitStatus();
        if (channel.isClosed() && printActivity && VERBOSE) {
            System.out.println("Channel is closed with exit status:" + channel.getExitStatus());
        }
        channel.disconnect();
        try {
            ((PipedInputStream)in).close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            ((PipedInputStream)err).close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return sshResponse;
    }
}

