/*
 * Decompiled with CFR 0.152.
 */
package utils.sound.util;

import java.io.File;
import java.util.Calendar;
import java.util.Date;

public class Utils {
    public static String formatNumber(long i, int digits) {
        return Utils.formatNumberImpl(i, digits, "0");
    }

    public static String formatNumberImpl(long i, int digits, String fill) {
        int ten = 10;
        String res = "";
        while (digits > 1) {
            if (i < (long)ten) {
                res = res + fill;
            }
            --digits;
            ten *= 10;
        }
        return res + String.valueOf(i);
    }

    public static String formatMinSec(long millis) {
        if (millis < 0L) {
            return " error";
        }
        return Utils.formatNumberImpl(millis / 60000L, 3, " ") + ":" + Utils.formatNumber(millis % 60000L / 1000L, 2);
    }

    public static String formatMinSecTenths(long millis) {
        if (millis < 0L) {
            return " ./.";
        }
        return Utils.formatMinSec(millis) + "." + Utils.formatNumberImpl(millis % 1000L / 100L, 1, " ");
    }

    public static long str2long(String s, long def) {
        try {
            def = Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return def;
    }

    public static String getFormattedDate(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(millis));
        return String.valueOf(cal.get(1)) + "-" + Utils.formatNumber(cal.get(2) + 1, 2) + "-" + Utils.formatNumber(cal.get(5), 2) + " " + Utils.formatNumber(cal.get(11), 2) + ":" + Utils.formatNumber(cal.get(12), 2) + ":" + Utils.formatNumber(cal.get(13), 2);
    }

    public static long align(long value, int al) {
        int rest = (int)(value % (long)al);
        return value - (long)rest;
    }

    public static int align(int value, int al) {
        int rest = value % al;
        return value - rest;
    }

    public static String stripExtension(String filename) {
        int ind = filename.lastIndexOf(".");
        if (ind == -1 || ind == filename.length() || filename.lastIndexOf(File.separator) > ind) {
            return filename;
        }
        return filename.substring(0, ind);
    }
}

