/*
 * Decompiled with CFR 0.152.
 */
package utils.sound.util;

import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import utils.message.Message;
import utils.message.MessageWriterInterface;

public abstract class SoundMessageBuffer
extends Thread {
    private AudioFormat formatOfNewPackets = null;
    private AudioFormat formatOfOldestPackets = null;
    private long currentBufferSizeInMS = 0L;
    private long maxBufferSizeInMS = 0L;
    private MessageWriterInterface messageWriter;
    private final Object LOCK = new Object();
    private boolean die = false;
    private LinkedList<AudioMessage> buffer = new LinkedList();

    protected abstract boolean isDataMessage(Message var1);

    protected abstract AudioFormat getAudioFormat(Message var1);

    public int getBytesInOneSecondOfSilence() {
        if (this.formatOfNewPackets == null) {
            return 0;
        }
        return (int)((float)this.formatOfNewPackets.getFrameSize() * this.formatOfNewPackets.getFrameRate());
    }

    public SoundMessageBuffer(long sizeInMS, MessageWriterInterface messageWriter) {
        this.maxBufferSizeInMS = sizeInMS;
        this.messageWriter = messageWriter;
        if (messageWriter != null) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        Object object = this.LOCK;
        synchronized (object) {
            this.die = true;
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataToBuffer(Message m, long audioTimeMS) {
        if (this.formatOfNewPackets == null) {
            return;
        }
        AudioMessage audioMessage = new AudioMessage(m, true);
        audioMessage.audioTimeMS = audioTimeMS;
        Object object = this.LOCK;
        synchronized (object) {
            boolean headIsAudioFormatMessage;
            this.buffer.add(audioMessage);
            this.currentBufferSizeInMS += audioMessage.audioTimeMS;
            boolean bl = headIsAudioFormatMessage = this.buffer.size() > 0 && this.buffer.getFirst().isDataMessage;
            while (this.currentBufferSizeInMS > this.maxBufferSizeInMS) {
                int index = 0;
                if (headIsAudioFormatMessage) {
                    index = 1;
                    if (this.buffer.size() <= 1) {
                        break;
                    }
                } else if (this.buffer.size() == 0) break;
                AudioMessage oldMessage = this.buffer.get(index);
                if (oldMessage.isDataMessage) {
                    oldMessage = this.buffer.remove(index);
                    this.currentBufferSizeInMS -= oldMessage.audioTimeMS;
                    continue;
                }
                if (headIsAudioFormatMessage) {
                    this.buffer.removeFirst();
                    this.formatOfOldestPackets = this.getAudioFormat(this.buffer.getFirst().source);
                    continue;
                }
                headIsAudioFormatMessage = true;
            }
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormatToBuffer(Message m) {
        AudioFormat format = this.getAudioFormat(m);
        Object object = this.LOCK;
        synchronized (object) {
            this.formatOfNewPackets = format;
            if (this.formatOfOldestPackets == null) {
                this.formatOfOldestPackets = format;
            }
            this.buffer.add(new AudioMessage(m, false));
            this.LOCK.notify();
        }
    }

    protected abstract void startBatch();

    protected abstract void batch(Message var1);

    protected abstract Message endBatch();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.die) {
            Message messageToSend;
            boolean empty;
            this.startBatch();
            Object object = this.LOCK;
            synchronized (object) {
                AudioMessage message2;
                while (this.buffer.size() == 0) {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                long batchBufferTimeMS = 0L;
                long startBatchTime = System.currentTimeMillis();
                while (this.buffer.size() > 0) {
                    message2 = this.buffer.removeFirst();
                    this.batch(message2.source);
                    batchBufferTimeMS += message2.audioTimeMS;
                }
                while (batchBufferTimeMS < 75L && System.currentTimeMillis() - startBatchTime < 75L) {
                    try {
                        this.LOCK.wait(System.currentTimeMillis() - startBatchTime);
                    }
                    catch (InterruptedException message2) {
                        // empty catch block
                    }
                    while (this.buffer.size() > 0) {
                        message2 = this.buffer.removeFirst();
                        this.batch(message2.source);
                        batchBufferTimeMS += message2.audioTimeMS;
                    }
                }
                empty = this.buffer.size() == 0;
                messageToSend = this.endBatch();
            }
            try {
                if (empty) {
                    this.messageWriter.write(messageToSend);
                    continue;
                }
                this.messageWriter.writeNoFlush(messageToSend);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private class AudioMessage {
        boolean isDataMessage;
        long audioTimeMS;
        Message source;

        public AudioMessage(Message message, boolean isDataMessage) {
            this.source = message;
            this.isDataMessage = isDataMessage;
        }
    }
}

