/*
 * Decompiled with CFR 0.152.
 */
package utils.sound.encoders.pcm;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class PCMPlayer
extends Thread {
    private final Mixer mixer;
    private SilenceThread silenceThread;
    private boolean forceFirstDelay = false;
    private InputStream inputStream;
    private int bufferSize;
    private AudioFormat format;
    private boolean die = false;
    private long lastAudioWriteCompleted = -1L;

    public PCMPlayer(InputStream inputStream, int bufferSize, AudioFormat format, boolean forceFirstDelay, Mixer mixer) {
        super("PCMPlayer");
        this.inputStream = inputStream;
        this.bufferSize = bufferSize;
        this.format = format;
        this.forceFirstDelay = forceFirstDelay;
        this.mixer = mixer;
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SourceDataLine speakers = this.mixer == null ? AudioSystem.getSourceDataLine(this.format) : AudioSystem.getSourceDataLine(this.format, this.mixer.getMixerInfo());
            speakers.open(this.format);
            this.silenceThread = new SilenceThread(speakers);
            this.silenceThread.start();
            System.out.println("[PCMPlayer] Starting with buffer size " + this.bufferSize);
            try {
                byte[] buffer = new byte[this.bufferSize];
                int read = 0;
                long startTime = System.currentTimeMillis() - System.currentTimeMillis() % 1000L;
                long decodedAudioBytes = 0L;
                while ((read = this.inputStream.read(buffer)) != -1 && !this.die) {
                    if (read <= 0) continue;
                    if (System.currentTimeMillis() > startTime + 1000L) {
                        System.out.println("[PCMPlayer] Audio over the last second: " + decodedAudioBytes + " bytes");
                        decodedAudioBytes = 0L;
                        startTime = System.currentTimeMillis() - System.currentTimeMillis() % 1000L;
                    }
                    decodedAudioBytes += (long)read;
                    try {
                        speakers.start();
                        speakers.write(buffer, 0, read);
                        this.lastAudioWriteCompleted = System.currentTimeMillis();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    int bytesPerSecond = (int)((float)this.format.getFrameSize() * this.format.getFrameRate());
                    byte[] silence500ms = PCMPlayer.getNBytesOfSilence(bytesPerSecond / 2);
                    speakers.write(silence500ms, 0, silence500ms.length);
                }
                catch (Throwable throwable) {}
                System.out.println("[PCMPlayer] Cleaning up...");
                try {
                    speakers.drain();
                }
                catch (Throwable throwable) {}
                Thread.sleep(500L);
                this.silenceThread.dieSilence = true;
                try {
                    speakers.stop();
                }
                catch (Throwable throwable) {}
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {}
                speakers.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("[PCMPlayer] Finished");
    }

    public void finish() {
        System.out.println("[PCMPlayer] Finishing.");
        this.die = true;
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] getNBytesOfSilence(int N) {
        byte[] silence100ms = new byte[N];
        for (int i = 0; i < silence100ms.length; ++i) {
            silence100ms[i] = i % 3 == 0 ? 0 : (i % 3 == 1 ? 1 : -1);
        }
        return silence100ms;
    }

    class SilenceThread
    extends Thread {
        private final SourceDataLine speakers;
        private boolean dieSilence = false;

        public SilenceThread(SourceDataLine speakers) {
            this.speakers = speakers;
            System.out.println("[SilenceThread] Started");
        }

        @Override
        public void run() {
            while (!this.dieSilence) {
                long diff;
                if (PCMPlayer.this.lastAudioWriteCompleted != -1L && (diff = System.currentTimeMillis() - PCMPlayer.this.lastAudioWriteCompleted) > 500L) {
                    System.out.println("[SilenceThread] No audio for 500ms. Draining.");
                    this.speakers.drain();
                    diff = System.currentTimeMillis() - PCMPlayer.this.lastAudioWriteCompleted;
                    if (diff > 500L) {
                        System.out.println("[SilenceThread] Stopping.");
                        this.speakers.stop();
                        PCMPlayer.this.lastAudioWriteCompleted = -1L;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void die() {
            this.dieSilence = true;
        }
    }
}

