/*
 * Decompiled with CFR 0.152.
 */
package utils.simplegraphs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import utils.simplegraphs.ColorUtil;
import utils.simplegraphs.TimeValueModel;
import utils.simplegraphs.gradient.RoundGradientPaint;

public class SimplePieChart
extends JPanel {
    private Color backgroundColor = Color.white;
    private BasicStroke stroke = null;
    public ArrayList pieces = new ArrayList();
    public ArrayList gray_pieces = new ArrayList();
    private int buffer = 15;
    private boolean borderPie = true;
    private Color borderColor = Color.GRAY.darker();
    private String noDataString = null;
    boolean grayscale = true;

    public void setGrayScale(boolean grayScale) {
        this.grayscale = grayScale;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(3.0f, 0, 2);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setStroke(this.stroke);
        int width = this.getWidth();
        int height = this.getHeight();
        int radius = (Math.min(width, height) - this.buffer) / 2;
        double total = 0.0;
        boolean dataAvailable = true;
        ArrayList currentPieces = this.grayscale ? this.gray_pieces : this.pieces;
        for (int i = 0; i < currentPieces.size(); ++i) {
            PiePiece piece = (PiePiece)currentPieces.get(i);
            if (piece.model.getSize() == 0) {
                dataAvailable = false;
            }
            total += piece.model.getLastValue();
        }
        if (!dataAvailable) {
            g2d.setColor(Color.BLACK);
            String str = "N/A";
            if (this.noDataString != null) {
                str = this.noDataString;
            }
            TextLayout tl = new TextLayout(str, g2d.getFont(), g2d.getFontRenderContext());
            Rectangle2D bounds = tl.getBounds();
            tl.draw(g2d, (float)(((double)width - bounds.getWidth()) / 2.0), (float)((double)(height / 2) + bounds.getHeight() / 2.0));
            return;
        }
        int startAngle = 0;
        for (int i = 0; i < currentPieces.size(); ++i) {
            PiePiece piece = (PiePiece)currentPieces.get(i);
            double percentage = piece.model.getLastValue() / total;
            int arcAngle = (int)(percentage * 360.0);
            if (i == currentPieces.size() - 1) {
                arcAngle = 360 - startAngle;
            }
            Point2D.Float center = new Point2D.Float(width / 2, height / 2);
            RoundGradientPaint p = new RoundGradientPaint(((Point2D)center).getX(), ((Point2D)center).getY(), piece.fillColor, new Point2D.Double(radius, radius), piece.fillColor.darker());
            g2d.setPaint(p);
            g2d.fillArc(width / 2 - radius, height / 2 - radius, 2 * radius, 2 * radius, startAngle, arcAngle);
            if (this.borderPie) {
                g2d.setColor(piece.lineColor);
                g2d.drawArc(width / 2 - radius, height / 2 - radius, 2 * radius, 2 * radius, startAngle, arcAngle);
                int angle = startAngle + arcAngle;
                double radAngle = (double)angle * Math.PI / 180.0;
                double xOffset = (double)radius * Math.cos(radAngle);
                double yOffset = (double)radius * Math.sin(radAngle);
                g2d.drawLine(width / 2, height / 2, (int)((double)(width / 2) + xOffset), (int)((double)(height / 2) - yOffset));
                angle = startAngle;
                radAngle = (double)angle * Math.PI / 180.0;
                xOffset = (double)radius * Math.cos(radAngle);
                yOffset = (double)radius * Math.sin(radAngle);
                g2d.drawLine(width / 2, height / 2, (int)((double)(width / 2) + xOffset), (int)((double)(height / 2) - yOffset));
            }
            startAngle += arcAngle;
        }
        if (this.borderPie) {
            g2d.setColor(this.borderColor);
            g2d.drawArc(width / 2 - (radius + 1), height / 2 - (radius + 1), (radius + 1) * 2, (radius + 1) * 2, 0, 360);
        }
    }

    public void addMetric(TimeValueModel model, Color lineColor, Color fillColor) {
        PiePiece piece = new PiePiece();
        piece.model = model;
        piece.fillColor = fillColor;
        piece.lineColor = lineColor;
        this.pieces.add(piece);
        piece = new PiePiece();
        piece.model = model;
        piece.fillColor = ColorUtil.toGrayscale(fillColor);
        piece.lineColor = ColorUtil.toGrayscale(lineColor);
        this.gray_pieces.add(piece);
    }

    public boolean isBorderPie() {
        return this.borderPie;
    }

    public void setBorderPie(boolean borderPie) {
        this.borderPie = borderPie;
    }

    public String getNoDataString() {
        return this.noDataString;
    }

    public void setNoDataString(String noDataString) {
        this.noDataString = noDataString;
    }

    public class PiePiece {
        TimeValueModel model;
        Color lineColor;
        Color fillColor;
    }
}

