/*
 * Decompiled with CFR 0.152.
 */
package utils.radius.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.radius.tls.CombinedHash;
import utils.radius.tls.TlsCipher;
import utils.radius.tls.TlsNullCipher;
import utils.radius.tls.TlsProtocolHandler;
import utils.radius.tls.TlsUtils;

class RecordStream {
    private TlsProtocolHandler handler;
    private InputStream is;
    private OutputStream os;
    private CombinedHash hash;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;

    RecordStream(TlsProtocolHandler handler, InputStream is, OutputStream os) {
        this.handler = handler;
        this.is = is;
        this.os = os;
        this.hash = new CombinedHash();
        this.writeCipher = this.readCipher = new TlsNullCipher();
    }

    public RecordStream(TlsProtocolHandler handler) {
        this.handler = handler;
        this.hash = new CombinedHash();
        this.writeCipher = this.readCipher = new TlsNullCipher();
    }

    void clientCipherSpecDecided(TlsCipher tlsCipher) {
        this.writeCipher = tlsCipher;
    }

    void serverClientSpecReceived() {
        this.readCipher = this.writeCipher;
    }

    public void setInputStream(ByteArrayInputStream stream) {
        this.is = stream;
    }

    public void setOutputStream(ByteArrayOutputStream stream) {
        this.os = stream;
    }

    public void readData() throws IOException {
        short type = TlsUtils.readUint8(this.is);
        TlsUtils.checkVersion(this.is, this.handler);
        int size = TlsUtils.readUint16(this.is);
        byte[] buf = this.decodeAndVerify(type, this.is, size);
        this.handler.processData(type, buf, 0, buf.length);
    }

    protected byte[] decodeAndVerify(short type, InputStream is, int len) throws IOException {
        byte[] buf = new byte[len];
        TlsUtils.readFully(buf, is);
        return this.readCipher.decodeCiphertext(type, buf, 0, buf.length);
    }

    protected void writeMessage(short type, byte[] message, int offset, int len) throws IOException {
        if (type == 22) {
            this.updateHandshakeData(message, offset, len);
        }
        byte[] ciphertext = this.writeCipher.encodePlaintext(type, message, offset, len);
        byte[] writeMessage = new byte[ciphertext.length + 5];
        TlsUtils.writeUint8(type, writeMessage, 0);
        TlsUtils.writeUint8((short)3, writeMessage, 1);
        TlsUtils.writeUint8((short)1, writeMessage, 2);
        TlsUtils.writeUint16(ciphertext.length, writeMessage, 3);
        System.arraycopy(ciphertext, 0, writeMessage, 5, ciphertext.length);
        this.os.write(writeMessage);
        this.os.flush();
    }

    public boolean hasMore() throws IOException {
        return this.is.available() > 0;
    }

    void updateHandshakeData(byte[] message, int offset, int len) {
        this.hash.update(message, offset, len);
    }

    byte[] getCurrentHash() {
        return RecordStream.doFinal(new CombinedHash(this.hash));
    }

    protected void close() throws IOException {
        IOException e = null;
        try {
            this.is.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            e = ex;
        }
        if (e != null) {
            throw e;
        }
    }

    protected void flush() throws IOException {
        this.os.flush();
    }

    private static byte[] doFinal(CombinedHash ch) {
        byte[] bs = new byte[ch.getDigestSize()];
        ch.doFinal(bs, 0);
        return bs;
    }
}

