/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.time;

import java.util.HashMap;
import java.util.LinkedList;
import utils.progtools.time.TimeValue;

public class TimeSet {
    private HashMap<String, TimeValue> timers = new HashMap();
    private LinkedList<String> titles = new LinkedList();

    public static void main(String[] args) {
        TimeSet set = new TimeSet();
        set.start("123");
        set.stop("123");
        set.start("123as asd as");
        set.stop("123as asd as");
        set.dumpMetrics();
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public void start(String title) {
        TimeValue value = this.timers.get(title);
        if (value == null) {
            value = new TimeValue();
            this.timers.put(title, value);
            this.titles.add(title);
        }
        value.time.reset();
    }

    public void stop(String title) {
        TimeValue value = this.timers.get(title);
        if (value == null) {
            System.out.println("[TimeSet] Stopping " + title + " without starting it.");
        } else {
            value.totalTime += value.time.lap();
            ++value.calls;
        }
    }

    public void dumpMetrics() {
        int max = 0;
        for (String title : this.titles) {
            max = Math.max(max, title.length());
        }
        System.out.print(TimeSet.padRight("Title", max += 2));
        System.out.print(TimeSet.padLeft("Total Time", 20));
        System.out.print(TimeSet.padLeft("Calls", 20));
        System.out.print(TimeSet.padLeft("Average Per Call", 20));
        System.out.println();
        for (String title : this.titles) {
            TimeValue value = this.timers.get(title);
            if (value.calls == 0) {
                System.out.println(title + " -> Started but never stopped");
                continue;
            }
            System.out.print(TimeSet.padRight(title, max));
            System.out.print(TimeSet.padLeft(value.totalTime + "", 20));
            System.out.print(TimeSet.padLeft(value.calls + "", 20));
            System.out.print(TimeSet.padLeft(value.totalTime / (long)value.calls + "", 20));
            System.out.println();
        }
    }
}

