/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.statemonitor;

import java.util.ArrayList;
import java.util.HashMap;
import utils.progtools.Counter;
import utils.progtools.statemonitor.CollectionsIntrospector;
import utils.progtools.statemonitor.NamedObject;

public class CollectionsMonitor
extends Thread {
    public static boolean PRINT_ALL_STATE = false;
    public static boolean PRINT_ALL_STATE_GT10 = true;
    CollectionsIntrospector intro;

    public CollectionsMonitor(CollectionsIntrospector intro) {
        this.intro = intro;
        this.start();
    }

    private String pad(String val) {
        while (val.length() < 12) {
            val = val + " ";
        }
        return val;
    }

    @Override
    public void run() {
        HashMap maxes = new HashMap();
        while (true) {
            try {
                ArrayList<NamedObject> list = this.intro.getAllCollections();
                Counter<String> counter = new Counter<String>();
                for (NamedObject namedObject : list) {
                    counter.add(CollectionsIntrospector.getTypeDesc(namedObject) + namedObject.name, CollectionsIntrospector.getSize(namedObject));
                }
                counter.sortByValue(false);
                ArrayList keys = counter.getSortedKeys();
                for (Object key : keys) {
                    int size = counter.getInt((String)key);
                    if (!PRINT_ALL_STATE && (!PRINT_ALL_STATE_GT10 || size <= 10)) continue;
                    System.out.println("[StateMonitor] " + this.pad("" + size) + " - " + key);
                }
                boolean bl = true;
                for (Object key : keys) {
                    int value = counter.getInt((String)key);
                    Integer prev = (Integer)maxes.get(key);
                    if (prev != null) {
                        boolean bl2;
                        if (value <= prev) continue;
                        if (bl2) {
                            bl2 = false;
                            System.out.println("[StateMonitor] L@@K " + keys.size() + " monitored collections");
                        }
                        System.out.println("[StateMonitor] L@@K, New Max : " + counter.getInt((String)key) + " - " + key);
                        maxes.put(key, new Integer(value));
                        continue;
                    }
                    maxes.put(key, new Integer(value));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                System.gc();
                Thread.sleep(60000L);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }
}

