/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.statemonitor;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import utils.progtools.Cache;
import utils.progtools.statemonitor.NamedObject;

public class CollectionsIntrospector {
    public static boolean DEBUG = false;
    public static boolean DEBUG_NEW_OBJS = false;
    Object objs_LOCK = new Object();
    ArrayList<WeakReference<NamedObject>> objs = new ArrayList();

    public static void main(String[] args) throws Exception {
        try {
            Class<?> c = Class.forName(args[0]);
            CollectionsIntrospector.introspect(c, args, 1);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            System.out.println("Usage: Introspector <class> var1a,var1b var2a,var2b ...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<NamedObject> getAllCollections() {
        Object object = this.objs_LOCK;
        synchronized (object) {
            ArrayList<NamedObject> rets = new ArrayList<NamedObject>();
            for (int i = 0; i < this.objs.size(); ++i) {
                NamedObject no = (NamedObject)this.objs.get(i).get();
                if (no == null) {
                    this.objs.remove(i--);
                    continue;
                }
                rets.add(no);
            }
            return rets;
        }
    }

    public static String getTypeDesc(NamedObject no) {
        if (no == null) {
            return "Null  ";
        }
        Object val = no.object;
        if (val instanceof Collection) {
            return "List  ";
        }
        if (val instanceof Map) {
            return "Map   ";
        }
        if (val instanceof Properties) {
            return "Props ";
        }
        if (val instanceof Object[]) {
            return "Array ";
        }
        return no.object.getClass().getName() + " ";
    }

    public static int getSize(NamedObject no) {
        if (no == null) {
            return -1;
        }
        Object val = no.object;
        if (val instanceof Collection) {
            return ((Collection)val).size();
        }
        if (val instanceof Map) {
            return ((Map)val).size();
        }
        if (val instanceof Properties) {
            return ((Properties)val).size();
        }
        if (val instanceof Object[]) {
            return ((Object[])val).length;
        }
        return -1;
    }

    public void buildCollectionsList(Object source, String name) {
        long T = System.currentTimeMillis();
        HashMap seen = new HashMap();
        ArrayList<NamedObject> tmp = new ArrayList<NamedObject>();
        ArrayList<Ref> refs = CollectionsIntrospector.buildCollectionsList(source, name, seen, tmp, false);
        while (refs.size() > 0) {
            ArrayList<Ref> next = new ArrayList<Ref>();
            for (Ref ref : refs) {
                next.addAll(CollectionsIntrospector.buildCollectionsList(ref.value, ref.name, seen, tmp, ref.missContents));
            }
            refs = next;
        }
        for (NamedObject no : tmp) {
            this.addIfNotMonitoring(no);
        }
        T = System.currentTimeMillis() - T;
        System.out.println("[Introspector] Took " + T + "ms " + (new String[5] instanceof Object[]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIfNotMonitoring(NamedObject no) {
        if (no != null) {
            Object object = this.objs_LOCK;
            synchronized (object) {
                boolean exists = false;
                for (WeakReference<NamedObject> ref : this.objs) {
                    NamedObject have = (NamedObject)ref.get();
                    if (have == null || no.object != have.object) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    if (DEBUG_NEW_OBJS) {
                        System.out.println("[Introspector] Collection: " + no.name + ", x" + CollectionsIntrospector.getSize(no));
                    }
                    this.objs.add(new WeakReference<NamedObject>(no));
                }
            }
        }
    }

    private static ArrayList<Ref> buildCollectionsList(Object source, String name, HashMap seen, ArrayList<NamedObject> found, boolean skipThis) {
        ArrayList<Ref> further = new ArrayList<Ref>();
        if (source == null) {
            return further;
        }
        if (DEBUG) {
            System.out.println("[Introspector] " + name + " (" + source.getClass().getName() + ") (" + seen.size() + ")");
        }
        if (!seen.containsKey(source)) {
            boolean missContents = false;
            if (source instanceof Cache) {
                if (DEBUG) {
                    System.out.println("[Introspector] Ignore (cache etc)");
                }
                missContents = true;
            } else if (source instanceof Collection || source instanceof Map || source instanceof Properties || source instanceof Object[]) {
                if (skipThis) {
                    if (DEBUG) {
                        System.out.println("[Introspector] Ignore (extended collection)");
                    }
                } else {
                    NamedObject no = new NamedObject(name, source);
                    found.add(no);
                    if (DEBUG) {
                        System.out.println("[Introspector] Add");
                    }
                }
            }
            String cname = source.getClass().getName();
            if (cname.startsWith("java.") || cname.startsWith("javax.") || cname.startsWith("sun.")) {
                if (DEBUG) {
                    System.out.println("[Introspector] JVM");
                }
            } else {
                seen.put(source, source);
                ClassContents contents = CollectionsIntrospector.getClassContents(source.getClass());
                if (source instanceof Object[]) {
                    Object[] values;
                    if (DEBUG) {
                        System.out.println("[Introspector] Follow array x" + Array.getLength(source));
                    }
                    for (Object value : values = (Object[])source) {
                        Ref ref = new Ref();
                        ref.value = value;
                        ref.name = name + "[]";
                        ref.missContents = missContents;
                        if (seen.containsKey(value)) continue;
                        further.add(ref);
                    }
                } else {
                    if (DEBUG) {
                        System.out.println("[Introspector] Follow x" + contents.fields.size());
                    }
                    for (Field field : contents.fields) {
                        try {
                            Object value;
                            if (!field.isAccessible()) {
                                field.setAccessible(true);
                            }
                            if ((value = field.get(source)) == null) continue;
                            Ref ref = new Ref();
                            ref.value = value;
                            ref.name = name + "." + field.getName();
                            ref.missContents = missContents;
                            if (seen.containsKey(value)) continue;
                            further.add(ref);
                        }
                        catch (IllegalAccessException x) {
                            x.printStackTrace();
                        }
                    }
                }
            }
        } else if (DEBUG) {
            System.out.println("[Introspector] Seen");
        }
        return further;
    }

    public static ClassContents getClassContents(Class c) {
        ClassContents contents = new ClassContents();
        while (c != Object.class) {
            if (c.isArray()) {
                contents.isArray = true;
            }
            Field[] tmp = c.getDeclaredFields();
            for (int i = 0; i < tmp.length; ++i) {
                contents.fields.add(tmp[i]);
                contents.classes.add(c);
            }
            c = c.getSuperclass();
        }
        return contents;
    }

    private static void introspect(Class c, String[] args, int level) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList classes = new ArrayList();
        while (c != Object.class) {
            Field[] tmp = c.getDeclaredFields();
            System.out.println(c.getName() + " = " + tmp.length + " fields");
            for (int i = 0; i < tmp.length; ++i) {
                fields.add(tmp[i]);
                classes.add(c);
            }
            c = c.getSuperclass();
        }
        String[] list = new String[]{};
        try {
            list = args[level].split(",");
        }
        catch (Exception i) {
            // empty catch block
        }
        for (int i = 0; i < fields.size(); ++i) {
            int k;
            Field ff = (Field)fields.get(i);
            Class cc = (Class)classes.get(i);
            for (k = 0; k < level; ++k) {
                System.out.print("\t");
            }
            if (ff.isAccessible()) {
                System.out.print("(OK) ");
            }
            System.out.print("(" + cc.getName() + ") ");
            System.out.println(ff.getType().getName() + " " + ff.getName());
            for (k = 0; k < list.length; ++k) {
                if (!ff.getName().equals(list[k])) continue;
                CollectionsIntrospector.introspect(ff.getType(), args, level + 1);
            }
        }
    }

    static class ClassContents {
        boolean isArray = false;
        ArrayList<Field> fields = new ArrayList();
        ArrayList<Class> classes = new ArrayList();

        ClassContents() {
        }
    }

    static class Ref {
        Object value;
        String name;
        boolean missContents;

        Ref() {
        }
    }
}

