/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.text.DecimalFormat;

public class HistogramTracker {
    public static int[] limits;
    public long[] vals;
    Object LOCK = new Object();

    public HistogramTracker(int steps, int min, int max) {
        limits = new int[steps + 1];
        this.vals = new long[steps + 1];
        double exponent = Math.pow(max / min, 1.0 / (double)(steps - 1));
        double val = min;
        for (int i = 0; i < steps + 1; ++i) {
            HistogramTracker.limits[i] = (int)val;
            val *= exponent;
        }
    }

    private HistogramTracker() {
    }

    public HistogramTracker cloneSelf() {
        HistogramTracker buckets = new HistogramTracker();
        limits = (int[])limits.clone();
        buckets.vals = (long[])this.vals.clone();
        return buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            for (int i = 0; i < this.vals.length; ++i) {
                this.vals[i] = 0L;
            }
        }
    }

    public String getReadout(String prefix, boolean header, boolean data) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (header) {
            sb.append("  " + prefix + " Bands:");
            DecimalFormat dfMs = new DecimalFormat("000");
            DecimalFormat df = new DecimalFormat("#.0");
            for (i = 0; i < limits.length; ++i) {
                int num = limits[i];
                if (i == limits.length - 1) {
                    sb.append(">>>");
                    continue;
                }
                if (num < 1000) {
                    sb.append(dfMs.format(num) + "|");
                    continue;
                }
                if (num < 10000) {
                    sb.append(df.format((double)num / 1000.0) + "|");
                    continue;
                }
                sb.append(num / 1000 + "s|");
            }
            sb.append("\n");
        }
        if (data) {
            double total = 0.0;
            for (i = 0; i < this.vals.length; ++i) {
                total += (double)this.vals[i];
            }
            double frac = 100.0 / total;
            DecimalFormat df = new DecimalFormat("0");
            sb.append("  " + prefix + " Vals :");
            if (!Double.isNaN(frac) && !Double.isInfinite(frac)) {
                for (int i2 = 0; i2 < this.vals.length; ++i2) {
                    double pc = frac * (double)this.vals[i2];
                    if (pc == 0.0) {
                        sb.append("    ");
                        continue;
                    }
                    String str = df.format(Math.min(99.0, pc));
                    if (str.length() == 1) {
                        sb.append(" " + str + "% ");
                        continue;
                    }
                    sb.append(str + "% ");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measured(long rtt) {
        for (int i = 0; i < limits.length; ++i) {
            if (rtt > (long)limits[i]) continue;
            Object object = this.LOCK;
            synchronized (object) {
                int n = i;
                this.vals[n] = this.vals[n] + 1L;
            }
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            int n = this.vals.length - 1;
            this.vals[n] = this.vals[n] + 1L;
        }
    }

    public static void main(String[] args) throws Exception {
        HistogramTracker ht = new HistogramTracker(10, 50, 20000);
        ht.measured(10L);
        ht.measured(102L);
        ht.measured(1032L);
        ht.measured(104L);
        ht.measured(10L);
        ht.measured(1023323L);
        ht.measured(1230L);
        ht.measured(140L);
        System.out.println(ht.getReadout("Test", true, true));
    }
}

