/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class EnElapsedTimeFormatter {
    private static final long ONE_SEC = 1000L;
    private static final long ONE_MIN = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_MONTH = 2678400000L;
    private static final long ONE_YEAR = 31536000000L;
    private static final DecimalFormat df = new DecimalFormat("#######################0.#################################");
    private static final SimpleDateFormat ABBREVIATED_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat ABBREVIATED_TIME_FORMAT_NOMS = new SimpleDateFormat("HH:mm:ss");

    protected boolean isBad(double t) {
        return Double.isNaN(t) || Double.isInfinite(t) || Double.MAX_VALUE == t || Double.MIN_VALUE == t;
    }

    public String getFormattedTimeAgo(long timeInMillis) {
        if (this.isBad(timeInMillis)) {
            return "-";
        }
        return this.getFormattedTime(timeInMillis) + " ago";
    }

    public String getFormattedTimeIn(long timeInMillis) {
        if (this.isBad(timeInMillis)) {
            return "-";
        }
        return "In " + this.getFormattedTime(timeInMillis);
    }

    public String getFormattedTime(long timeInMillis) {
        if (this.isBad(timeInMillis)) {
            return "";
        }
        if (timeInMillis < 1000L) {
            if (timeInMillis == 1L) {
                return df.format(timeInMillis) + " ms";
            }
            return df.format(timeInMillis) + " ms";
        }
        if (timeInMillis < 60000L) {
            if (timeInMillis / 1000L == 1L) {
                return df.format(timeInMillis / 1000L) + " sec";
            }
            return df.format(timeInMillis / 1000L) + " secs";
        }
        if (timeInMillis < 3600000L) {
            if (timeInMillis / 60000L == 1L) {
                return df.format(timeInMillis / 60000L) + " min";
            }
            return df.format(timeInMillis / 60000L) + " mins";
        }
        if (timeInMillis < 86400000L) {
            if (timeInMillis / 3600000L == 1L) {
                return df.format(timeInMillis / 3600000L) + " hr";
            }
            return df.format(timeInMillis / 3600000L) + " hrs";
        }
        if (timeInMillis < 2678400000L) {
            if (timeInMillis / 86400000L == 1L) {
                return df.format(timeInMillis / 86400000L) + " day";
            }
            return df.format(timeInMillis / 86400000L) + " days";
        }
        if (timeInMillis > 2678400000L && timeInMillis < 32140800000L) {
            if (timeInMillis / 2678400000L == 1L) {
                return df.format(timeInMillis / 2678400000L) + " month";
            }
            return df.format(timeInMillis / 2678400000L) + " months";
        }
        if (timeInMillis / 31536000000L == 1L) {
            return df.format(timeInMillis / 31536000000L) + " year";
        }
        return df.format(timeInMillis / 31536000000L) + " years";
    }

    public String getAbbreviatedFormattedTime(long timeInMillis, boolean useMS) {
        if (timeInMillis == 0L) {
            return "";
        }
        if (this.isBad(timeInMillis)) {
            return "";
        }
        String cur = "";
        long remaining = 0L;
        if (timeInMillis < 1000L || timeInMillis < 60000L || timeInMillis < 3600000L || timeInMillis < 86400000L) {
            cur = useMS ? ABBREVIATED_TIME_FORMAT.format(new Date(timeInMillis)) : ABBREVIATED_TIME_FORMAT_NOMS.format(new Date(timeInMillis));
        } else if (timeInMillis < 2678400000L) {
            cur = timeInMillis / 86400000L == 1L ? df.format(timeInMillis / 86400000L) + " day" : df.format(timeInMillis / 86400000L) + " days";
            remaining = timeInMillis % 86400000L;
        } else if (timeInMillis > 2678400000L && timeInMillis < 32140800000L) {
            cur = timeInMillis / 2678400000L == 1L ? df.format(timeInMillis / 2678400000L) + " month" : df.format(timeInMillis / 2678400000L) + " months";
            remaining = timeInMillis % 2678400000L;
        } else {
            cur = timeInMillis / 31536000000L == 1L ? df.format(timeInMillis / 31536000000L) + " year" : df.format(timeInMillis / 31536000000L) + " years";
            remaining = timeInMillis % 31536000000L;
        }
        return cur + " " + this.getAbbreviatedFormattedTime(remaining, useMS);
    }

    public String getCompleteFormattedTime(long timeInMillis) {
        return this.getCompleteFormattedTime(timeInMillis, true);
    }

    public String getCompleteFormattedTime(long timeInMillis, boolean includeMillis) {
        if (timeInMillis == 0L) {
            return "";
        }
        if (this.isBad(timeInMillis)) {
            return "";
        }
        if (!includeMillis) {
            timeInMillis = 1000L * (timeInMillis / 1000L);
        }
        String cur = "";
        long remaining = 0L;
        if (timeInMillis < 1000L) {
            cur = timeInMillis == 1L ? df.format(timeInMillis) + " ms" : df.format(timeInMillis) + " ms";
        } else if (timeInMillis < 60000L) {
            cur = timeInMillis / 1000L == 1L ? df.format(timeInMillis / 1000L) + " sec" : df.format(timeInMillis / 1000L) + " secs";
            remaining = timeInMillis % 1000L;
        } else if (timeInMillis < 3600000L) {
            cur = timeInMillis / 60000L == 1L ? df.format(timeInMillis / 60000L) + " min" : df.format(timeInMillis / 60000L) + " mins";
            remaining = timeInMillis % 60000L;
        } else if (timeInMillis < 86400000L) {
            cur = timeInMillis / 3600000L == 1L ? df.format(timeInMillis / 3600000L) + " hr" : df.format(timeInMillis / 3600000L) + " hrs";
            remaining = timeInMillis % 3600000L;
        } else if (timeInMillis < 2678400000L) {
            cur = timeInMillis / 86400000L == 1L ? df.format(timeInMillis / 86400000L) + " day" : df.format(timeInMillis / 86400000L) + " days";
            remaining = timeInMillis % 86400000L;
        } else if (timeInMillis > 2678400000L && timeInMillis < 32140800000L) {
            cur = timeInMillis / 2678400000L == 1L ? df.format(timeInMillis / 2678400000L) + " month" : df.format(timeInMillis / 2678400000L) + " months";
            remaining = timeInMillis % 2678400000L;
        } else {
            cur = timeInMillis / 31536000000L == 1L ? df.format(timeInMillis / 31536000000L) + " year" : df.format(timeInMillis / 31536000000L) + " years";
            remaining = timeInMillis % 31536000000L;
        }
        String nextBit = this.getCompleteFormattedTime(remaining);
        return (cur + " " + nextBit).trim();
    }

    public String getCompressedFormattedTime(long timeInMillis, boolean ms) {
        StringBuffer sb = new StringBuffer();
        long N = timeInMillis / 2678400000L;
        sb.append('M');
        sb.append(N);
        sb.append('-');
        N = (timeInMillis %= 2678400000L) / 86400000L;
        if (N < 10L) {
            sb.append('0');
        }
        sb.append(N);
        sb.append(' ');
        N = (timeInMillis %= 86400000L) / 3600000L;
        if (N < 10L) {
            sb.append('0');
        }
        sb.append(N);
        sb.append(':');
        N = (timeInMillis %= 3600000L) / 60000L;
        if (N < 10L) {
            sb.append('0');
        }
        sb.append(N);
        sb.append(':');
        N = (timeInMillis %= 60000L) / 1000L;
        if (N < 10L) {
            sb.append('0');
        }
        sb.append(N);
        if (ms) {
            sb.append('.');
            N = timeInMillis %= 1000L;
            if (N < 100L) {
                sb.append('0');
            } else if (N < 10L) {
                sb.append('0');
                sb.append('0');
            }
            sb.append(N);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        EnElapsedTimeFormatter et = new EnElapsedTimeFormatter();
        System.out.println(et.getCompleteFormattedTime(123123123L));
        System.out.println(et.getCompleteFormattedTime(123123123L, false));
        System.out.println(et.getAbbreviatedFormattedTime(123123123L, false));
        System.out.println(et.getCompressedFormattedTime(123123123L, false));
        System.out.println(et.getCompressedFormattedTime(System.currentTimeMillis(), true));
    }

    static {
        ABBREVIATED_TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        ABBREVIATED_TIME_FORMAT_NOMS.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

