/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DataUtil {
    private static final DecimalFormat spdf = new DecimalFormat("###,###,###,###,###,##0.#");
    private static final NumberFormat percentageFormat = NumberFormat.getPercentInstance();

    public static String getSensiblePercentage(double percentage) {
        return percentageFormat.format(percentage);
    }

    public static String getSensibleSpeed(double speedHz) {
        String metric;
        if (speedHz < 1000.0) {
            metric = "Hz";
        } else if (speedHz < Math.pow(1000.0, 2.0)) {
            metric = "KHz";
            speedHz /= 1000.0;
        } else if (speedHz < Math.pow(1000.0, 3.0)) {
            metric = "MHz";
            speedHz /= Math.pow(1000.0, 2.0);
        } else {
            metric = "GHz";
            speedHz /= Math.pow(1000.0, 3.0);
        }
        if (speedHz * 10.0 % 10.0 == 0.0) {
            return speedHz + " " + metric;
        }
        return spdf.format(speedHz) + " " + metric;
    }

    public static String getSensibleSize(long sizeBytes) {
        String metric;
        double size = sizeBytes;
        if (size < 1024.0) {
            metric = "B";
        } else if (size < Math.pow(1024.0, 2.0)) {
            metric = "KB";
            size /= 1024.0;
        } else if (size < Math.pow(1024.0, 3.0)) {
            metric = "MB";
            size /= Math.pow(1024.0, 2.0);
        } else {
            metric = "GB";
            size /= Math.pow(1024.0, 3.0);
        }
        if (size * 10.0 % 10.0 == 0.0) {
            return (long)size + " " + metric;
        }
        return spdf.format(size) + " " + metric;
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }
}

