/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.File;
import java.io.IOException;
import utils.progtools.TimeoutMap;

public class AccessLockManager {
    private final Object map_LOCK = new Object();
    TimeoutMap<String, Object> map = new TimeoutMap();
    long maxTimeInUse;
    private static AccessLockManager TEST_LOCKS = new AccessLockManager(30000L);

    public AccessLockManager(long maxTimeInUseMs) {
        this.maxTimeInUse = maxTimeInUseMs;
    }

    public Object getOnDemandLock(File file) {
        try {
            return this.getOnDemandLock(file.getCanonicalPath());
        }
        catch (IOException x) {
            return this.getOnDemandLock(file.getName());
        }
    }

    public Object getOnDemandLock(long N) {
        return this.getOnDemandLock("" + N);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOnDemandLock(String path) {
        if (path == null) {
            return new Object();
        }
        Object object = this.map_LOCK;
        synchronized (object) {
            Object pathLock = this.map.get(path);
            if (pathLock == null) {
                pathLock = new Object();
                this.map.put(path, pathLock, this.maxTimeInUse);
            }
            return pathLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.map_LOCK;
        synchronized (object) {
            return this.map.size();
        }
    }

    public static void main(String[] args) throws Exception {
        new Test("Alice").start();
        new Test("Bob").start();
        new Test("Cara").start();
        while (TEST_LOCKS.size() > 0) {
            Thread.sleep(5000L);
            System.out.println("Still have " + TEST_LOCKS.size() + " locks");
        }
        System.out.println("No locks remaining");
        System.exit(0);
    }

    private static class Test
    extends Thread {
        String name;

        public Test(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = TEST_LOCKS.getOnDemandLock("test");
            synchronized (object) {
                System.out.println(this.name + " got lock");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println(this.name + " released lock");
            }
        }
    }
}

