/*
 * Decompiled with CFR 0.152.
 */
package utils.ostools.win32;

import java.io.File;
import java.util.ArrayList;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.string.CharStack;
import utils.string.Normaliser;

public class FirewallAdder {
    public static void main(String[] args) throws Exception {
        FirewallAdder.removeRulesStartingWith("SHRemote");
        File test = new File("C:\\Users\\SimpleHelp\\Desktop\\test.exe");
        FirewallAdder.addExe(test, "This is a name for our rule", "This is a description for our rule");
    }

    public static void removeRulesStartingWith(String prefix) {
        if (OS.isWindowsVistaOrAbove()) {
            ArrayList<String> rulesToRemove = new ArrayList<String>();
            RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(new String[]{"netsh", "advfirewall", "firewall", "show", "rule", "name=all"});
            if (commandResponse != null && commandResponse.returnCode == 0) {
                CharStack stack = new CharStack(commandResponse.stdout);
                while (!stack.isEmpty()) {
                    String name;
                    stack.popUntil("Rule Name:", false);
                    if (stack.isEmpty() || !(name = stack.popLine(true).trim()).startsWith(prefix) || rulesToRemove.contains(name)) continue;
                    rulesToRemove.add(name);
                }
            }
            for (String s : rulesToRemove) {
                System.out.println("[FirewallAdder] Removing old rule " + s);
                RunCommandGetOutput.runCommand(new String[]{"netsh", "advfirewall", "firewall", "delete", "rule", "name=" + s});
            }
        } else {
            ArrayList<String> rulesToRemove = new ArrayList<String>();
            RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(new String[]{"netsh", "firewall", "show", "allowedprogram"});
            if (commandResponse != null && commandResponse.returnCode == 0) {
                CharStack stack = new CharStack(commandResponse.stdout);
                stack.popUntil("-----");
                stack.popUntil('\n', false);
                while (!stack.isEmpty()) {
                    stack.popWhitespace();
                    if (stack.isEmpty()) continue;
                    stack.popText(true);
                    stack.popWhitespace();
                    String name = stack.popUntil('/', true).trim();
                    stack.pop();
                    stack.popWhitespace();
                    String program = stack.popUntil('\n', true).trim();
                    if (!name.startsWith(prefix) || rulesToRemove.contains(program)) continue;
                    rulesToRemove.add(program);
                }
            }
            for (String s : rulesToRemove) {
                System.out.println("[FirewallAdder] Removing old rule " + s);
                RunCommandGetOutput.runCommand(new String[]{"netsh", "firewall", "delete", "allowedprogram", s});
            }
        }
    }

    public static void addExe(File file, String name, String description) {
        RunCommandGetOutput.CommandResponse response;
        if (!file.exists()) {
            System.out.println("[FirewallAdder] Skipping as file does not exist yet.");
        }
        String exe = Normaliser.removeQuotes(file.getAbsolutePath());
        name = Normaliser.removeQuotes(name);
        if (OS.isWindowsVistaOrAbove()) {
            String[] command = new String[]{"netsh", "advfirewall", "firewall", "add", "rule", "name=" + name + "", "description=" + description + "", "dir=in", "action=allow", "program=" + exe};
            response = RunCommandGetOutput.runCommand(command);
        } else {
            response = RunCommandGetOutput.runCommand(new String[]{"netsh.exe", "firewall", "add", "allowedprogram", "" + exe + "", "" + name + "", "ENABLE"});
        }
        if (response == null || response.error != null || response.returnCode != 0) {
            System.out.println("[FwAdder] Failed to add (" + name + ") " + exe);
            if (response != null) {
                System.out.println("[FwAdder] Error (" + response.returnCode + ")");
                if (response.error != null) {
                    response.error.printStackTrace();
                }
                if (response.stdout != null) {
                    System.out.println("[FwAdder] Stdout: " + response.stdout);
                }
                if (response.stderr != null) {
                    System.out.println("[FwAdder] Stderr: " + response.stdout);
                }
            }
        } else {
            System.out.println("[FwAdder] Added rule: " + name);
        }
    }
}

