/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.types;

import java.util.Random;
import utils.message.Message;
import utils.osstats.linux.LinuxBasicInfo;
import utils.osstats.osx.OSXBasicInfo;
import utils.osstats.types.DiskConfig;
import utils.osstats.types.MemoryConfig;
import utils.osstats.types.ProcessorConfig;
import utils.osstats.windows.WindowsBasicInfo;
import utils.ostools.OS;
import utils.string.CharStack;

public abstract class BasicInfo {
    private static long lastLoadTime = 0L;
    private static final byte VERSION = 0;
    public static final int TYPE_WINDOWS = 0;
    public static final int TYPE_OSX = 1;
    public static final int TYPE_LINUX = 2;
    public long memoryTotalBytes;
    protected long lastBootTime;
    public String computerModelName;
    public String computerModelIdentifier;
    public String computerModelManufacturer;
    public String serial;
    public boolean eccMemory;
    public MemoryConfig[] memoryConfig = new MemoryConfig[0];
    public DiskConfig[] diskConfig = new DiskConfig[0];
    public ProcessorConfig[] processorConfig = new ProcessorConfig[0];
    private static BasicInfo INSTANCE;

    protected abstract void readBasicInfo();

    public boolean isBlank() {
        if (this.memoryTotalBytes == 0L && this.processorConfig.length == 0) {
            System.out.println("[BasicInfo] Basic info collection failed. Results are empty. Retrying...");
            return true;
        }
        return false;
    }

    public static BasicInfo fromMessage(Message m) {
        BasicInfo info;
        switch (m.getType()) {
            case 0: {
                info = new WindowsBasicInfo(m);
                break;
            }
            case 1: {
                info = new OSXBasicInfo(m);
                break;
            }
            case 2: {
                info = new LinuxBasicInfo(m);
                break;
            }
            default: {
                return null;
            }
        }
        return info;
    }

    protected void loadFromMessage(Message m) {
        int i;
        byte version = m.getNextByte();
        this.memoryTotalBytes = m.getNextLong();
        this.lastBootTime = m.getNextLong();
        this.computerModelName = m.getNextString();
        this.computerModelIdentifier = m.getNextString();
        this.computerModelManufacturer = m.getNextString();
        this.serial = m.getNextString();
        this.eccMemory = m.getNextBoolean();
        int count = m.getNextInt();
        this.memoryConfig = new MemoryConfig[count];
        for (i = 0; i < this.memoryConfig.length; ++i) {
            MemoryConfig memory = new MemoryConfig();
            memory.capacityBytes = m.getNextLong();
            memory.manufacturer = m.getNextString();
            memory.speedHz = m.getNextLong();
            memory.status = m.getNextString();
            memory.type = m.getNextString();
            this.memoryConfig[i] = memory;
        }
        count = m.getNextInt();
        this.diskConfig = new DiskConfig[count];
        for (i = 0; i < count; ++i) {
            DiskConfig disk = new DiskConfig();
            disk.capacityBytes = m.getNextLong();
            disk.deviceName = m.getNextString();
            disk.disk = m.getNextString();
            disk.internal = m.getNextBoolean();
            disk.mediaName = m.getNextString();
            disk.protocol = m.getNextString();
            disk.type = m.getNextString();
            this.diskConfig[i] = disk;
        }
        count = m.getNextInt();
        this.processorConfig = new ProcessorConfig[count];
        for (i = 0; i < count; ++i) {
            ProcessorConfig processor = new ProcessorConfig();
            processor.coreCount = m.getNextInt();
            processor.is64bit = m.getNextBoolean();
            processor.processorName = m.getNextString();
            processor.processorSpeedHz = m.getNextLong();
            this.processorConfig[i] = processor;
        }
    }

    public Message toMessage() {
        Message m = null;
        m = this instanceof WindowsBasicInfo ? new Message(0) : (this instanceof OSXBasicInfo ? new Message(1) : (this instanceof LinuxBasicInfo ? new Message(2) : new Message()));
        m.append((byte)0);
        m.append(this.memoryTotalBytes);
        m.append(this.lastBootTime);
        m.append(this.computerModelName);
        m.append(this.computerModelIdentifier);
        m.append(this.computerModelManufacturer);
        m.append(this.serial);
        m.append(this.eccMemory);
        if (this.memoryConfig == null) {
            m.append(0);
        } else {
            m.append(this.memoryConfig.length);
            for (MemoryConfig mem : this.memoryConfig) {
                m.append(mem.capacityBytes);
                m.append(mem.manufacturer);
                m.append(mem.speedHz);
                m.append(mem.status);
                m.append(mem.type);
            }
        }
        if (this.diskConfig == null) {
            m.append(0);
        } else {
            m.append(this.diskConfig.length);
            for (DiskConfig disk : this.diskConfig) {
                m.append(disk.capacityBytes);
                m.append(disk.deviceName);
                m.append(disk.disk);
                m.append(disk.internal);
                m.append(disk.mediaName);
                m.append(disk.protocol);
                m.append(disk.type);
            }
        }
        if (this.processorConfig == null) {
            m.append(0);
        } else {
            m.append(this.processorConfig.length);
            for (ProcessorConfig processor : this.processorConfig) {
                m.append(processor.coreCount);
                m.append(processor.is64bit);
                m.append(processor.processorName);
                m.append(processor.processorSpeedHz);
            }
        }
        return m;
    }

    public BasicInfo() {
    }

    public BasicInfo(boolean fake) {
        int i;
        Random r = new Random();
        this.memoryTotalBytes = 0x100000000L;
        this.lastBootTime = System.currentTimeMillis() - (long)r.nextInt(259200000);
        this.computerModelName = "MacBook Pro - " + r.nextInt(10);
        this.computerModelIdentifier = "MacBookPro12," + r.nextInt(5);
        this.computerModelManufacturer = "Apple";
        this.serial = "AABBCCDDEEFF";
        this.eccMemory = r.nextBoolean();
        int slots = r.nextInt(10);
        this.memoryConfig = new MemoryConfig[slots];
        for (i = 0; i < this.memoryConfig.length; ++i) {
            this.memoryConfig[i] = new MemoryConfig();
            this.memoryConfig[i].speedHz = 1800000000L;
            this.memoryConfig[i].type = "PCI";
            this.memoryConfig[i].status = "OK";
            this.memoryConfig[i].capacityBytes = (long)Math.pow(1024.0, 3.0);
            this.memoryConfig[i].manufacturer = "Manufacturer";
        }
        slots = r.nextInt(5);
        this.diskConfig = new DiskConfig[slots];
        for (i = 0; i < this.diskConfig.length; ++i) {
            this.diskConfig[i] = new DiskConfig();
            this.diskConfig[i].capacityBytes = (long)(20.0 * Math.pow(1024.0, 3.0) * (double)r.nextInt(40));
            this.diskConfig[i].type = "SSD";
            this.diskConfig[i].mediaName = "Sample Media Name for Drive " + i;
            this.diskConfig[i].disk = "Disk #" + i;
            this.diskConfig[i].protocol = "SCSI";
            this.diskConfig[i].internal = r.nextBoolean();
        }
        slots = r.nextInt(8);
        this.processorConfig = new ProcessorConfig[slots];
        for (i = 0; i < this.processorConfig.length; ++i) {
            this.processorConfig[i] = new ProcessorConfig();
            this.processorConfig[i].processorName = "Intel Core i7";
            this.processorConfig[i].processorSpeedHz = BasicInfo.getAsHertz("3." + r.nextInt(10) + " GHz");
            this.processorConfig[i].coreCount = 2;
            this.processorConfig[i].is64bit = true;
        }
    }

    public static BasicInfo getBasicInfo() {
        if (INSTANCE == null) {
            lastLoadTime = System.currentTimeMillis();
            if (OS.isWindows()) {
                INSTANCE = new WindowsBasicInfo();
            } else if (OS.isMacOS()) {
                INSTANCE = new OSXBasicInfo();
            } else if (OS.isLinux()) {
                INSTANCE = new LinuxBasicInfo();
            }
        } else if (INSTANCE.isBlank() && System.currentTimeMillis() - lastLoadTime > 60000L) {
            INSTANCE.readBasicInfo();
            lastLoadTime = System.currentTimeMillis();
        }
        return INSTANCE;
    }

    public long getUptime() {
        if (this.lastBootTime == -1L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.lastBootTime;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("Model Name: ").append(this.computerModelName).append("\n");
        builder.append("Model Identifier: ").append(this.computerModelIdentifier).append("\n");
        builder.append("Model Manufacturer: ").append(this.computerModelManufacturer).append("\n");
        builder.append("Serial: ").append(this.serial).append("\n");
        builder.append("Memory Total: ").append(this.memoryTotalBytes).append("\n");
        for (i = 0; i < this.processorConfig.length; ++i) {
            ProcessorConfig processor = this.processorConfig[i];
            builder.append("Processor ").append(i).append("\n");
            builder.append("\tProcessor Name: ").append(processor.processorName).append("\n");
            builder.append("\tProcessor Speed: ").append(processor.processorSpeedHz).append(" hz\n");
            builder.append("\tNumber of Cores: ").append(processor.coreCount).append("\n");
            builder.append("\t64Bit: ").append(processor.is64bit).append("\n");
        }
        builder.append("Last Boot Time: ").append(this.lastBootTime).append("\n");
        builder.append("ECC Memory: ").append(this.eccMemory).append("\n");
        for (i = 0; i < this.memoryConfig.length; ++i) {
            builder.append("Memory Slot ").append(i).append("\n");
            builder.append("\tType: ").append(this.memoryConfig[i].type).append("\n");
            builder.append("\tCapacity: ").append(this.memoryConfig[i].capacityBytes).append(" bytes\n");
            builder.append("\tSpeed: ").append(this.memoryConfig[i].speedHz).append(" hz\n");
            builder.append("\tStatus: ").append(this.memoryConfig[i].status).append("\n");
            builder.append("\tManufacturer: ").append(this.memoryConfig[i].manufacturer).append("\n");
        }
        for (i = 0; i < this.diskConfig.length; ++i) {
            builder.append("Disk ").append(i).append(": ").append(this.diskConfig[i].disk).append('\n');
            builder.append("\tDevice Name: ").append(this.diskConfig[i].deviceName).append("\n");
            builder.append("\tMedia Name: ").append(this.diskConfig[i].mediaName).append("\n");
            builder.append("\tCapacity: ").append(this.diskConfig[i].capacityBytes).append(" bytes\n");
            builder.append("\tMedium Type: ").append(this.diskConfig[i].type).append("\n");
            builder.append("\tProtocol: ").append(this.diskConfig[i].protocol).append("\n");
            builder.append("\tInternal: ").append(this.diskConfig[i].internal).append("\n");
        }
        return builder.toString();
    }

    protected static long getAsBytes(String value) {
        if ((value = value.toLowerCase()).contains("tb")) {
            double result = Double.parseDouble(value.substring(0, value.indexOf("tb")));
            return (long)(result *= Math.pow(1024.0, 4.0));
        }
        if (value.contains("gb")) {
            double result = Double.parseDouble(value.substring(0, value.indexOf("gb")));
            return (long)(result *= Math.pow(1024.0, 3.0));
        }
        if (value.contains("mb")) {
            double result = Double.parseDouble(value.substring(0, value.indexOf("mb")));
            return (long)(result *= Math.pow(1024.0, 2.0));
        }
        if (value.contains("kb")) {
            double result = Double.parseDouble(value.substring(0, value.indexOf("kb")));
            return (long)(result *= 1024.0);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    protected static long getAsHertz(String value) {
        return BasicInfo.getAsHertz(value, 1L);
    }

    protected static long getAsHertz(String value, long defaultUnits) {
        if (value == null || value.length() == 0) {
            return 0L;
        }
        if ((value = value.toLowerCase()).contains("ghz")) {
            double result = Double.parseDouble(value.substring(0, value.indexOf("ghz")));
            return (long)(result *= Math.pow(1000.0, 3.0));
        }
        if (value.contains("mhz")) {
            double result = Double.parseDouble(value.substring(0, value.indexOf("mhz")));
            return (long)(result *= Math.pow(1000.0, 2.0));
        }
        if (value.contains("khz")) {
            double result = Double.parseDouble(value.substring(0, value.indexOf("khz")));
            return (long)(result *= 1000.0);
        }
        try {
            if (value.contains(".")) {
                value = value.substring(0, value.indexOf(46));
            }
            return defaultUnits * Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    protected static long getAsLong(String value, long defaultIfNullOrException) {
        if (value == null || value.length() == 0) {
            return defaultIfNullOrException;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return defaultIfNullOrException;
        }
    }

    public int getProcessorCount() {
        if (this.processorConfig == null) {
            return 0;
        }
        return this.processorConfig.length;
    }

    public boolean matchesFilter(String filter) {
        if (filter == null) {
            return false;
        }
        if (this.computerModelName != null && this.computerModelName.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.computerModelIdentifier != null && this.computerModelIdentifier.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.computerModelManufacturer != null && this.computerModelManufacturer.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.serial != null && this.serial.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.memoryConfig != null) {
            for (MemoryConfig memoryConfig : this.memoryConfig) {
                if (memoryConfig.manufacturer != null && memoryConfig.manufacturer.toLowerCase().contains(filter)) {
                    return true;
                }
                if (memoryConfig.type == null || !memoryConfig.type.toLowerCase().contains(filter)) continue;
                return true;
            }
        }
        if (this.processorConfig != null) {
            for (ProcessorConfig processorConfig : this.processorConfig) {
                if (processorConfig.processorName == null || !processorConfig.processorName.toLowerCase().contains(filter)) continue;
                return true;
            }
        }
        if (this.diskConfig != null) {
            for (DiskConfig diskConfig : this.diskConfig) {
                if (diskConfig.deviceName != null && diskConfig.deviceName.toLowerCase().contains(filter)) {
                    return true;
                }
                if (diskConfig.mediaName != null && diskConfig.mediaName.toLowerCase().contains(filter)) {
                    return true;
                }
                if (diskConfig.disk != null && diskConfig.disk.toLowerCase().contains(filter)) {
                    return true;
                }
                if (diskConfig.type != null && diskConfig.type.toLowerCase().contains(filter)) {
                    return true;
                }
                if (diskConfig.protocol == null || !diskConfig.protocol.toLowerCase().contains(filter)) continue;
                return true;
            }
        }
        return false;
    }

    public int getDiskCount() {
        if (this.diskConfig == null) {
            return 0;
        }
        return this.diskConfig.length;
    }

    public int getMemoryCount() {
        if (this.memoryConfig == null) {
            return 0;
        }
        return this.memoryConfig.length;
    }

    public String getBiosVersion() {
        StringBuilder result = new StringBuilder();
        if (this instanceof WindowsBasicInfo) {
            WindowsBasicInfo wInfo = (WindowsBasicInfo)this;
            if (wInfo.biosVersion != null) {
                result.append(wInfo.biosVersion.trim());
            }
            if (wInfo.biosReleaseDate != null) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(wInfo.biosReleaseDate.trim());
            }
        } else {
            if (this instanceof OSXBasicInfo) {
                OSXBasicInfo osxInfo = (OSXBasicInfo)this;
                return osxInfo.SMCVersion;
            }
            LinuxBasicInfo wInfo = (LinuxBasicInfo)this;
            if (wInfo.biosVersion != null) {
                result.append(wInfo.biosVersion.trim());
            }
            if (wInfo.biosReleaseDate != null) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(wInfo.biosReleaseDate.trim());
            }
        }
        return result.toString();
    }

    public String getBiosNameAndVendor() {
        StringBuilder result = new StringBuilder();
        if (this instanceof WindowsBasicInfo) {
            WindowsBasicInfo wInfo = (WindowsBasicInfo)this;
            if (wInfo.biosName != null) {
                result.append(wInfo.biosName.trim());
            }
            if (wInfo.biosVendor != null) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(wInfo.biosVendor.trim());
            }
        } else {
            if (this instanceof OSXBasicInfo) {
                OSXBasicInfo osxInfo = (OSXBasicInfo)this;
                return osxInfo.bootROMVersion;
            }
            LinuxBasicInfo wInfo = (LinuxBasicInfo)this;
            if (wInfo.biosVendor != null) {
                result.append(wInfo.biosVendor.trim());
            }
        }
        return result.toString();
    }

    public String getBiosSummary() {
        StringBuilder result = new StringBuilder();
        if (this instanceof WindowsBasicInfo) {
            WindowsBasicInfo wInfo = (WindowsBasicInfo)this;
            if (wInfo.biosName != null) {
                result.append(wInfo.biosName.trim());
            }
            if (wInfo.biosVendor != null) {
                if (result.length() > 0) {
                    result.append(" - ");
                }
                result.append(wInfo.biosVendor.trim());
            }
            if (wInfo.biosReleaseDate != null || wInfo.biosVersion != null) {
                result.append(" (");
                if (wInfo.biosReleaseDate != null) {
                    result.append(wInfo.biosReleaseDate.trim());
                }
                if (wInfo.biosVersion != null) {
                    if (wInfo.biosReleaseDate != null) {
                        result.append(", ");
                    }
                    result.append(wInfo.biosVersion.trim());
                }
                result.append(")");
            }
            return result.toString();
        }
        if (this instanceof OSXBasicInfo) {
            OSXBasicInfo osxInfo = (OSXBasicInfo)this;
            return osxInfo.bootROMVersion + " - " + osxInfo.SMCVersion;
        }
        if (this instanceof LinuxBasicInfo) {
            LinuxBasicInfo wInfo = (LinuxBasicInfo)this;
            if (wInfo.biosVendor != null) {
                result.append(wInfo.biosVendor.trim());
            }
            if (wInfo.biosReleaseDate != null || wInfo.biosVersion != null) {
                result.append(" (");
                if (wInfo.biosReleaseDate != null) {
                    result.append(wInfo.biosReleaseDate.trim());
                }
                if (wInfo.biosReleaseDate != null) {
                    if (wInfo.biosReleaseDate != null) {
                        result.append(", ");
                    }
                    result.append(wInfo.biosVersion.trim());
                }
                result.append(")");
            }
            return result.toString();
        }
        return null;
    }

    protected long parseUptimeOutput(String output) {
        CharStack stack = new CharStack(output);
        stack.popUntil("up");
        long days = 0L;
        if (output.contains(" day")) {
            stack.popWhitespace();
            days = stack.popInteger();
            stack.popUntil(",");
        }
        stack.popWhitespace();
        long hours = 0L;
        long minutes = 0L;
        if (output.contains(" min")) {
            minutes = stack.popInteger();
        } else if (output.contains(" hrs")) {
            hours = stack.popInteger();
        } else {
            hours = stack.popInteger();
            stack.pop();
            minutes = stack.popInteger();
        }
        return System.currentTimeMillis() - ((days * 24L + hours) * 60L + minutes) * 60L * 1000L;
    }

    public long getTotalMemory() {
        long total = 0L;
        if (this.memoryConfig != null) {
            for (MemoryConfig config : this.memoryConfig) {
                total += config.capacityBytes;
            }
        }
        return total;
    }
}

