/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.av;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Pattern;
import utils.osstats.AbstractStats;
import utils.osstats.LinuxStats;
import utils.osstats.MacOSStats;
import utils.osstats.Stats;
import utils.osstats.WindowsStats;
import utils.osstats.winutils.WMIProvider;
import utils.osstats.winutils.WMIRegistry;
import utils.osstats.winutils.WMIResults;
import utils.osstats.winutils.WmicRows;
import utils.osstats.winutils.WmicUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.string.CharStack;
import utils.string.SimpleRegex;

public class SecurityProduct {
    private static final String NS_SEC1 = "/namespace:\\\\root\\SecurityCenter";
    private static final String NS_SEC2 = "/namespace:\\\\root\\SecurityCenter2";
    private static boolean DEBUG_SHOW_PROCS_SERVICES = false;
    private String name = "Unknown";
    private boolean isFirewall = false;
    private boolean active = false;
    private boolean upToDate = false;
    private static ArrayList<AvProduct> osxAvs = new ArrayList();
    private static ArrayList<AvProduct> winAvs = new ArrayList();
    private static ArrayList<AvProduct> linuxAvs = new ArrayList();

    public boolean isActive() {
        return this.active;
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }

    public boolean isFirewall() {
        return this.isFirewall;
    }

    public String getName() {
        return this.name;
    }

    private static int checkBit(int state, int bit) {
        return 1 & state >> bit - 1;
    }

    private static boolean checkUpToDate(int state) {
        return 0 == SecurityProduct.checkBit(state, 9);
    }

    private static boolean checkOnAccessScanning(int state) {
        return 1 == SecurityProduct.checkBit(state, 13);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<SecurityProduct> list = SecurityProduct.getAVProducts();
        for (SecurityProduct sec : list) {
            System.out.println(sec);
        }
        int state = 393488;
        System.out.println("State");
        System.out.println("Active: " + SecurityProduct.checkOnAccessScanning(state) + " (on-access scanning)");
        System.out.println("Up to date: " + SecurityProduct.checkUpToDate(state));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isFirewall) {
            sb.append("(Firewall) ");
        } else {
            sb.append("(AV) ");
        }
        sb.append(this.name);
        sb.append(" ").append(this.upToDate ? "recent" : "old");
        sb.append(" ").append(this.active ? "active" : "inactive");
        return sb.toString();
    }

    private static void process(ArrayList<HashMap<String, String>> data, ArrayList<SecurityProduct> secs, boolean isFirewall) {
        for (HashMap<String, String> product : data) {
            SecurityProduct winsec = new SecurityProduct();
            winsec.isFirewall = isFirewall;
            winsec.name = product.get("displayName");
            if (OS.isWindows7OrAbove()) {
                int state = Integer.parseInt(product.get("productState"));
                winsec.upToDate = SecurityProduct.checkUpToDate(state);
                winsec.active = SecurityProduct.checkOnAccessScanning(state);
                System.out.println("[SecProd] Name:" + winsec.name + " = " + Integer.toHexString(state) + " (active:" + winsec.active + " / upToDate:" + winsec.upToDate + ")");
            } else {
                winsec.upToDate = product.get("productUptoDate").trim().equalsIgnoreCase("true");
                winsec.active = product.get("onAccessScanningEnabled").trim().equalsIgnoreCase("true");
                System.out.println("[SecProd] Name:" + winsec.name + " (active:" + winsec.active + " / upToDate:" + winsec.upToDate + ")");
            }
            secs.add(winsec);
        }
    }

    private static void printRows(WmicRows rows) {
        ArrayList<HashMap<String, String>> list = rows.toHashMap();
        for (HashMap<String, String> map : list) {
            Object[] keys = map.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                String val = map.get(key);
                System.out.println((String)key + " = " + val);
            }
            System.out.println("");
        }
    }

    private static AvProduct newOsxAV(String name) {
        AvProduct av = new AvProduct(name);
        osxAvs.add(av);
        return av;
    }

    private static AvProduct newWinAV(String name) {
        AvProduct av = new AvProduct(name);
        winAvs.add(av);
        return av;
    }

    private static AvProduct newLinuxAv(String name) {
        AvProduct av = new AvProduct(name);
        linuxAvs.add(av);
        return av;
    }

    public static ArrayList<SecurityProduct> getAVProducts() {
        ArrayList<AvProduct> avs;
        AbstractStats stats;
        ArrayList<SecurityProduct> secs = new ArrayList<SecurityProduct>();
        if (OS.isMacOS()) {
            stats = new MacOSStats();
            avs = osxAvs;
        } else if (OS.isWindows()) {
            stats = new WindowsStats();
            avs = winAvs;
        } else if (OS.isLinux()) {
            stats = new LinuxStats();
            avs = linuxAvs;
        } else {
            stats = null;
            avs = null;
        }
        ArrayList<AvProduct> found = new ArrayList<AvProduct>();
        if (stats != null) {
            Stats.ProcessStatistic[] procs;
            stats.update();
            for (Stats.ProcessStatistic stat : procs = stats.getProcessStatistics()) {
                if (DEBUG_SHOW_PROCS_SERVICES) {
                    System.out.println("[SecProd] Process " + stat.name + " : " + stat.cmdLineNoArgs);
                }
                String cmd = stat.cmdLineNoArgs;
                cmd = cmd.substring(cmd.lastIndexOf(47) + 1);
                for (AvProduct av : avs) {
                    boolean add = false;
                    for (String procMatch : av.procs) {
                        Pattern p = SimpleRegex.simpleToPattern(procMatch, false);
                        if (p.matcher(stat.name).matches()) {
                            System.out.println("[SecProd] Process match " + stat.name + " : " + cmd + " (" + av + ")");
                            add = true;
                        } else if (p.matcher(cmd).matches()) {
                            System.out.println("[SecProd] Process match " + stat.name + " : " + cmd + " (" + av + ")");
                            add = true;
                        }
                        if (!add) continue;
                        break;
                    }
                    if (!add || found.contains(av)) continue;
                    found.add(av);
                }
            }
        }
        if (OS.isWindows()) {
            WMIProvider provider = WMIRegistry.getProvider();
            System.out.println("Provider: " + provider);
            if (provider != null) {
                Properties[] props;
                WMIResults data = provider.queryWMI("select Name,DisplayName,Started from Win32_Service");
                for (Properties prop : props = data.getProperties()) {
                    String name = prop.getProperty("Name");
                    String display = prop.getProperty("DisplayName");
                    String startstr = prop.getProperty("Started");
                    boolean started = false;
                    if (startstr != null) {
                        boolean bl = started = (startstr = startstr.trim()).equalsIgnoreCase("true") || startstr.equals("-1");
                    }
                    if (DEBUG_SHOW_PROCS_SERVICES) {
                        System.out.println("[SecProd] Service " + name + " : " + display);
                    }
                    for (AvProduct av : avs) {
                        boolean add = false;
                        for (String procMatch : av.services) {
                            Pattern p = SimpleRegex.simpleToPattern(procMatch, false);
                            if (p.matcher(name).matches()) {
                                System.out.println("[SecProd] Service match " + name + " : " + procMatch + " (" + av + ", started:" + started + ")");
                                if (started) {
                                    add = true;
                                }
                            } else if (p.matcher(display).matches()) {
                                System.out.println("[SecProd] Service match " + display + " : " + procMatch + " (" + av + ", started:" + started + ")");
                                if (started) {
                                    add = true;
                                }
                            }
                            if (!add) continue;
                            break;
                        }
                        if (!add || found.contains(av)) continue;
                        found.add(av);
                    }
                }
            }
        }
        HashMap<String, String> done = new HashMap<String, String>();
        for (AvProduct av : found) {
            if (done.containsKey(av.name)) continue;
            SecurityProduct sp = new SecurityProduct();
            sp.name = av.name;
            sp.active = true;
            sp.upToDate = true;
            sp.isFirewall = false;
            secs.add(sp);
            done.put(av.name, av.name);
        }
        if (OS.isMacOS()) {
            String result = RunCommandGetOutput.runCommandGetOutput(new String[]{"defaults", "read", "/Library/Preferences/com.apple.alf", "globalstate"})[0].trim();
            System.out.println(result);
            int state = Integer.parseInt(result);
            SecurityProduct sp = new SecurityProduct();
            sp.name = "MacOS X Firewall";
            sp.active = state == 1;
            sp.upToDate = true;
            sp.isFirewall = true;
            secs.add(sp);
        }
        boolean haveAV = false;
        for (SecurityProduct sec : secs) {
            if (!sec.isActive() || sec.isFirewall()) continue;
            haveAV = true;
        }
        if (!haveAV) {
            String[] avOutput;
            if (OS.isWindowsVistaOrAbove()) {
                RunCommandGetOutput.CommandResponse response;
                avOutput = WmicUtil.launchWmicCommandGetOutput(new String[]{NS_SEC2, "PATH", "AntiVirusProduct", "get"});
                String[] asOutput = WmicUtil.launchWmicCommandGetOutput(new String[]{NS_SEC2, "PATH", "AntiSpywareProduct", "get"});
                String[] fwOutput = WmicUtil.launchWmicCommandGetOutput(new String[]{NS_SEC2, "PATH", "FirewallProduct", "get"});
                WmicRows avRows = new WmicRows(avOutput[0]);
                WmicRows asRows = new WmicRows(asOutput[0]);
                WmicRows fwRows = new WmicRows(fwOutput[0]);
                SecurityProduct.process(avRows.toHashMap(), secs, false);
                SecurityProduct.process(asRows.toHashMap(), secs, false);
                SecurityProduct.process(fwRows.toHashMap(), secs, true);
                if (fwRows.getData().length == 0 && (response = RunCommandGetOutput.runCommand(new String[]{"cmd.exe", "/c", "netsh", "advfirewall", "show", "all", "State"})) != null && response.stdout != null) {
                    SecurityProduct winsec = new SecurityProduct();
                    winsec.isFirewall = true;
                    winsec.name = "Windows Firewall";
                    winsec.upToDate = true;
                    CharStack stack = new CharStack(response.stdout);
                    stack.popUntil("State");
                    boolean active = true;
                    while (!stack.isEmpty()) {
                        stack.popWhitespace();
                        String state = stack.popText(true);
                        if (!state.equalsIgnoreCase("ON")) {
                            active = false;
                        }
                        stack.popUntil("State");
                    }
                    winsec.active = active;
                    secs.add(winsec);
                }
            } else if (OS.isWindows()) {
                RunCommandGetOutput.CommandResponse response;
                avOutput = WmicUtil.launchWmicCommandGetOutput(new String[]{NS_SEC1, "PATH", "AntiVirusProduct", "get"});
                String[] fwOutput = WmicUtil.launchWmicCommandGetOutput(new String[]{NS_SEC1, "PATH", "FirewallProduct", "get"});
                WmicRows avRows = new WmicRows(avOutput[0]);
                WmicRows fwRows = new WmicRows(fwOutput[0]);
                SecurityProduct.process(avRows.toHashMap(), secs, false);
                SecurityProduct.process(fwRows.toHashMap(), secs, true);
                if (fwRows.getData().length == 0 && (response = RunCommandGetOutput.runCommand(new String[]{"cmd.exe", "/c", "netsh", "firewall", "show", "state"})) != null && response.stdout != null) {
                    CharStack stack = new CharStack(response.stdout);
                    stack.popUntil("Operational Mode");
                    stack.popUntil('=', false);
                    stack.popWhitespace();
                    String text = stack.popText(true);
                    SecurityProduct winsec = new SecurityProduct();
                    winsec.isFirewall = true;
                    winsec.name = "Windows Firewall";
                    winsec.upToDate = true;
                    winsec.active = text.equalsIgnoreCase("Enable");
                    secs.add(winsec);
                }
            }
        }
        return secs;
    }

    static {
        AvProduct avast = SecurityProduct.newWinAV("Avast");
        avast.procs.add("*avastsvc*");
        avast.procs.add("*aswidsagenta*");
        avast.services.add("avast! Antivirus");
        avast.services.add("avast*");
        AvProduct adaware = SecurityProduct.newWinAV("Ad-Aware");
        adaware.procs.add("*adawareservice*");
        adaware.services.add("*adawareantivirusservice*");
        adaware.procs.add("*ad-aware*");
        adaware.procs.add("*adaware*");
        adaware.services.add("*adaware*");
        adaware.services.add("*ad-aware*");
        AvProduct avg = SecurityProduct.newWinAV("AVG");
        avg.procs.add("avgsvca*");
        avg.procs.add("avguix*");
        avg.procs.add("avgsvc*");
        avg.services.add("avgsvc*");
        avg.services.add("AVG Service*");
        AvProduct avira = SecurityProduct.newWinAV("Avira");
        avira.procs.add("avira.servicehost*");
        avira.procs.add("avira.systray*");
        avira.services.add("avira.servicehost*");
        avira.services.add("AntiVirService*");
        avira.services.add("AntiVirSchedulerService*");
        avira.services.add("AviraUpdaterService*");
        AvProduct bdef = SecurityProduct.newWinAV("BitDefender");
        bdef.procs.add("ProductAgentService*");
        bdef.services.add("ProductAgentService");
        bdef.services.add("Bitdefender Product Agent Service");
        AvProduct comodo = SecurityProduct.newWinAV("Comodo AV");
        comodo.procs.add("cis.exe");
        comodo.procs.add("cmdagent.exe");
        comodo.services.add("cmdAgent");
        comodo.services.add("COMODO Internet Security Helper Service");
        comodo.services.add("cmdvirth");
        comodo.services.add("COMODO Virtual Service Manager");
        AvProduct drweb = SecurityProduct.newWinAV("Dr Web");
        drweb.procs.add("dwantispam*");
        drweb.procs.add("dwengine*");
        drweb.procs.add("dwarkdaemon*");
        drweb.procs.add("dwnetfilter*");
        drweb.procs.add("dwservice*");
        drweb.services.add("DrWebAVService");
        drweb.services.add("Dr.Web Control Service");
        drweb.services.add("DrWebNetFilter");
        drweb.services.add("Dr.Web Net Filtering Service");
        drweb.services.add("DrWebEngine");
        drweb.services.add("Dr.Web Scanning Engine*");
        AvProduct eset = SecurityProduct.newWinAV("ESET");
        eset.procs.add("ekm.exe");
        eset.services.add("ekm");
        eset.services.add("ESET Service");
        AvProduct fprot = SecurityProduct.newWinAV("F-Prot");
        fprot.procs.add("FPAVServer*");
        fprot.services.add("FPAVServer");
        fprot.services.add("F-PROT Antivirus*");
        AvProduct fsec = SecurityProduct.newWinAV("F-Secure");
        fsec.procs.add("fshoster*");
        fsec.services.add("fshoster");
        fsec.services.add("F-Secure Hoster");
        fsec.services.add("fsnethoster");
        fsec.services.add("F-Secure Hoster (Restricted)");
        AvProduct forti = SecurityProduct.newWinAV("Fortinet");
        forti.procs.add("FCHelper64.exe");
        forti.procs.add("FortiESNAC*");
        forti.procs.add("FortiTray*");
        forti.services.add("FA_Scheduler");
        forti.services.add("FortiClient Service Scheduler");
        AvProduct immu = SecurityProduct.newWinAV("Immunet");
        immu.procs.add("sfc.exe");
        immu.services.add("ImmunetProtect*");
        immu.services.add("Immunet*");
        AvProduct kasp = SecurityProduct.newWinAV("Kaspersky");
        kasp.procs.add("kdse.exe");
        kasp.procs.add("avp.exe");
        kasp.procs.add("avpui.exe");
        kasp.procs.add("kdseui.exe");
        kasp.services.add("KSDE*");
        kasp.services.add("Kaspersky Secure Connection Service*");
        kasp.services.add("AVP*");
        kasp.services.add("Kaspersky Anti-Virus Service*");
        AvProduct mbam = SecurityProduct.newWinAV("Malwarebytes");
        mbam.procs.add("mbam.exe");
        mbam.procs.add("mbamservice*");
        mbam.services.add("MBAMService*");
        mbam.services.add("Malwarebytes Service*");
        mbam.services.add("*Malwarebytes*");
        AvProduct mcafee = SecurityProduct.newWinAV("McAfee");
        mcafee.procs.add("McCSPServiceHost.exe");
        mcafee.procs.add("McSvHost.exe");
        mcafee.procs.add("McUICnt.exe");
        mcafee.procs.add("mfefire.exe");
        mcafee.services.add("mcpltsvc");
        mcafee.services.add("McAfee Platform Services");
        mcafee.services.add("McAPExe");
        mcafee.services.add("McAfee AP Service");
        mcafee.services.add("McMPFSvc");
        mcafee.services.add("McAfee Personal Firewall Service");
        mcafee.services.add("HomeNetSvc");
        mcafee.services.add("McAfee Home Network");
        AvProduct panda = SecurityProduct.newWinAV("Panda AV");
        panda.procs.add("PSANHost.exe");
        panda.procs.add("PSUAMain.exe");
        panda.procs.add("PSUAService.exe");
        panda.services.add("PandaAgent");
        panda.services.add("Panda Devices Agent");
        panda.services.add("PSUAService");
        panda.services.add("Panda Product Service");
        panda.services.add("NanoServiceMain");
        panda.services.add("Panda Protection Service");
        AvProduct sophos = SecurityProduct.newWinAV("Sophos");
        sophos.procs.add("SAVAdminService.exe");
        sophos.procs.add("SavService.exe");
        sophos.procs.add("swc_service.exe");
        sophos.procs.add("swi_service.exe");
        sophos.services.add("SAVService");
        sophos.services.add("Sophos Anti-Virus");
        sophos.services.add("SAVAdminService");
        sophos.services.add("Sophos Anti-Virus status reporter");
        sophos.services.add("swi_service");
        sophos.services.add("Sophos Web Intelligence Service");
        sophos.services.add("swi_service");
        sophos.services.add("Sophos Web Intelligence Service");
        sophos.services.add("swi_update_64");
        sophos.services.add("Sophos Web Intelligence Update");
        sophos.services.add("Sophos Web Control Service");
        sophos.services.add("sophossps");
        sophos.services.add("Sophos System Protection Service");
        AvProduct norton = SecurityProduct.newWinAV("Norton");
        norton.procs.add("NS.exe");
        norton.services.add("NS");
        norton.services.add("Norton Security*");
        AvProduct spybot = SecurityProduct.newWinAV("Spybot");
        spybot.procs.add("SDUpdSvc*");
        spybot.procs.add("SDWSCSvc*");
        spybot.services.add("SDScannerService*");
        spybot.services.add("SDWSCService*");
        spybot.services.add("Spybot*");
        AvProduct trend = SecurityProduct.newWinAV("Trend AV");
        trend.procs.add("PtSessionAgent*");
        trend.procs.add("PtSvcHost*");
        trend.procs.add("PtWatchDog*");
        trend.services.add("Amsp");
        trend.services.add("Trend Micro Solution Platform");
        trend.services.add("Trend Micro*");
        AvProduct webroot = SecurityProduct.newWinAV("Webroot");
        webroot.procs.add("WRSA*");
        webroot.services.add("WRSVC");
        AvProduct defender = SecurityProduct.newWinAV("Windows Defender");
        defender.services.add("WinDefend");
        defender.services.add("Windows Defender");
        avast = SecurityProduct.newOsxAV("Avast");
        avast.procs.add("com.avast.proxy*");
        avast.procs.add("com.avast.helper*");
        avast.procs.add("com.avast.AvastFileShield*");
        avast.procs.add("*MacAvast*");
        AvProduct sophos2 = SecurityProduct.newOsxAV("Sophos");
        sophos2.procs.add("InterCheck*");
        sophos2.procs.add("*Sophos*");
        AvProduct norton2 = SecurityProduct.newOsxAV("Norton");
        norton2.procs.add("SymDaemon");
        norton2.procs.add("Norton Antivirus");
        AvProduct mcafee2 = SecurityProduct.newOsxAV("McAfee");
        mcafee2.procs.add("VShieldCheck*");
        mcafee2.procs.add("VShieldScan*");
        mcafee2.procs.add("VShieldUpdate*");
        AvProduct avira2 = SecurityProduct.newOsxAV("Avira");
        avira2.procs.add("avguard*");
        AvProduct vbar = SecurityProduct.newOsxAV("Virus Barrier");
        vbar.procs.add("virusbarrier*");
        AvProduct clam = SecurityProduct.newOsxAV("ClamXAV / ProtectMac");
        clam.procs.add("clamd");
        eset = SecurityProduct.newOsxAV("ESET");
        eset.procs.add("esets_ctk*");
        eset.procs.add("esets_daemon*");
        eset.procs.add("esets_kac*");
        eset.procs.add("esets_mac*");
        eset.procs.add("esets_proxy*");
        eset.procs.add("esets_gui*");
        eset.procs.add("esets_esy*");
    }

    static class AvProduct {
        String name;
        ArrayList<String> procs = new ArrayList();
        ArrayList<String> services = new ArrayList();

        public AvProduct(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

