/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats;

import java.util.Iterator;
import utils.progtools.collections.FixedSizeLinkedList;
import utils.progtools.collections.ListReverser;

public class LoadAverageUtil {
    private FixedSizeLinkedList<AverageBucket> buckets;
    private long bucketSize;
    private int max;

    public LoadAverageUtil() {
        this(60000, 15);
    }

    public LoadAverageUtil(int bucketSize, int max) {
        this.bucketSize = bucketSize;
        this.max = max;
        this.buckets = new FixedSizeLinkedList(max);
    }

    public void addSample(long time, double value) {
        this.removeOldBuckets(time);
        this.addNewBuckets(time);
        this.buckets.peekLast().add(time, value);
    }

    public byte getAverage1Byte() {
        return (byte)this.getAverage1();
    }

    public byte getAverage5Byte() {
        return (byte)this.getAverage5();
    }

    public byte getAverage15Byte() {
        return (byte)this.getAverage15();
    }

    public double getAverage1() {
        if (this.buckets.isEmpty()) {
            return -1.0;
        }
        return this.getAverageN(1);
    }

    public double getAverage5() {
        if (this.buckets.isEmpty()) {
            return -1.0;
        }
        return this.getAverageN(5);
    }

    public double getAverage15() {
        if (this.buckets.isEmpty()) {
            return -1.0;
        }
        return this.getAverageN(15);
    }

    private double getAverageN(int N) {
        if (this.buckets.isEmpty()) {
            return -1.0;
        }
        double total = 0.0;
        int count = 0;
        Iterator<AverageBucket> it = new ListReverser<AverageBucket>(this.buckets.getList()).iterator();
        while (it.hasNext() && N > 0) {
            AverageBucket bucket = it.next();
            if (bucket.count > 0) {
                total += bucket.getAverage();
                ++count;
            }
            --N;
        }
        return total / (double)count;
    }

    public String toString() {
        return this.getAverage1() + " " + this.getAverage5() + " " + this.getAverage15();
    }

    private void addNewBuckets(long time) {
        long bucketTime = time - time % this.bucketSize;
        while (this.buckets.size() < this.max) {
            AverageBucket bucket;
            if (this.buckets.size() == 0) {
                bucket = new AverageBucket();
                bucket.startTime = bucketTime - this.bucketSize * (long)(this.max - 1);
                this.buckets.put(bucket);
                continue;
            }
            bucket = this.buckets.peekLast();
            AverageBucket newBucket = new AverageBucket();
            newBucket.startTime = bucket.startTime + this.bucketSize;
            this.buckets.put(newBucket);
        }
    }

    private void removeOldBuckets(long time) {
        while (this.buckets.size() > 0 && time - this.buckets.peek().startTime > (long)this.max * this.bucketSize) {
            this.buckets.pop();
        }
    }

    private class AverageBucket {
        double total;
        int count;
        long startTime;

        private AverageBucket() {
        }

        public boolean timeInBucket(long time) {
            return this.startTime <= time && time < this.startTime + LoadAverageUtil.this.bucketSize;
        }

        public void add(long time, double value) {
            if (!this.timeInBucket(time)) {
                throw new RuntimeException();
            }
            this.total += value;
            ++this.count;
        }

        public String toString() {
            double avg = 0.0;
            if (this.count > 0) {
                avg = this.total / (double)this.count;
            }
            return "start: " + this.startTime + " avg:" + avg + " total:" + this.total + " count:" + this.count;
        }

        public double getAverage() {
            if (this.count == 0) {
                return 0.0;
            }
            return this.total / (double)this.count;
        }
    }
}

