/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import utils.files.FileUtil;
import utils.message.Message;
import utils.osstats.AbstractStats;
import utils.osstats.Stats;
import utils.osstats.StatsUtil;
import utils.ostools.RunCommandGetOutput;
import utils.string.CharStack;
import utils.string.Chunker;

public class LinuxStats
extends AbstractStats {
    public LinuxStats() {
        super(false);
    }

    public LinuxStats(boolean fake) {
        super(fake);
    }

    public LinuxStats(Message loadFromMessage) {
        this.loadFromMessage(loadFromMessage);
    }

    @Override
    public void updateLight() {
        if (this.isFake) {
            Random r = new Random();
            this.usedMemoryBytes = (long)(r.nextDouble() * (double)this.basicInfo.memoryTotalBytes);
            this.cpuPercentage = Math.random() * 95.0;
            return;
        }
        this.updateCPUPercentage();
        this.updateUsedMemory();
    }

    private void updateCPUPercentage() {
        try {
            this.cpuPercentage = this.getCPUPercViaIOStat();
        }
        catch (Exception ex) {
            try {
                this.cpuPercentage = this.getCPUPercViaVMStat();
            }
            catch (Exception xx) {
                xx.printStackTrace();
            }
        }
    }

    private void updateUsedMemory() {
        try {
            String response = FileUtil.readFileAsString_NoBuffer(new File("/proc/meminfo"));
            CharStack stack = new CharStack(response);
            stack.popLine(false);
            stack.popText(false);
            stack.popWhitespace();
            long bytesFree = stack.popInteger() * 1024L;
            this.usedMemoryBytes = this.basicInfo.memoryTotalBytes - bytesFree;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void update() {
        if (this.isFake) {
            Random r = new Random();
            this.usedMemoryBytes = (long)(r.nextDouble() * (double)this.basicInfo.memoryTotalBytes);
            this.cpuPercentage = Math.random() * 95.0;
            this.diskSpaceStatistics = new Stats.DiskSpaceStatistic[0];
            this.processStatistics = new Stats.ProcessStatistic[0];
            this.wifiPercentage = Math.random() * 75.0;
            this.wifiMbit = 9.0 + Math.random() * 50.0;
            this.batteryPercentage = 75;
        } else {
            CharStack charStack;
            RunCommandGetOutput.CommandResponse response;
            this.loadBatteryValues();
            this.updateCPUPercentage();
            try {
                response = RunCommandGetOutput.runCommand(new String[]{"df", "-k"});
                if (response != null) {
                    charStack = new CharStack(response.stdout);
                    charStack.popUntil('\n', false);
                    charStack.popWhitespace();
                    ArrayList<Stats.DiskSpaceStatistic> disks = new ArrayList<Stats.DiskSpaceStatistic>();
                    while (!charStack.isEmpty()) {
                        String diskName = charStack.popText(true);
                        charStack.popWhitespace();
                        while (!charStack.isNextNumber()) {
                            diskName = diskName + charStack.popText(true);
                            charStack.popWhitespace();
                        }
                        long size = charStack.popInteger();
                        charStack.popWhitespace();
                        long used = charStack.popInteger();
                        charStack.popWhitespace();
                        long free = charStack.popInteger();
                        charStack.popWhitespace();
                        double pused = charStack.popNumber();
                        charStack.pop();
                        charStack.popWhitespace();
                        String mount = charStack.popText(true);
                        charStack.popUntil('\n', false);
                        charStack.popWhitespace();
                        Stats.DiskSpaceStatistic ds = new Stats.DiskSpaceStatistic();
                        ds.name = diskName + " (" + mount + ")";
                        ds.free = free * 1024L;
                        ds.used = used * 1024L;
                        disks.add(ds);
                    }
                    this.diskSpaceStatistics = disks.toArray(new Stats.DiskSpaceStatistic[0]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                response = RunCommandGetOutput.runCommand(new String[]{"ps", "axo", "pcpu,pmem,pid,user,rss,command"});
                if (response != null) {
                    charStack = new CharStack(response.stdout);
                    charStack.popUntil('\n', false);
                    charStack.popWhitespace();
                    ArrayList<Stats.ProcessStatistic> processes = new ArrayList<Stats.ProcessStatistic>();
                    while (!charStack.isEmpty()) {
                        double pcpu = charStack.popNumber();
                        charStack.popWhitespace();
                        double pmem = charStack.popNumber();
                        charStack.popWhitespace();
                        int pid = (int)charStack.popInteger();
                        charStack.popWhitespace();
                        String username = charStack.popText(true);
                        charStack.popWhitespace();
                        long rss = charStack.popInteger();
                        charStack.popWhitespace();
                        String command = charStack.popUntil('\n', true);
                        charStack.popWhitespace();
                        Stats.ProcessStatistic ps = new Stats.ProcessStatistic();
                        ps.cpuPercentage = (int)pcpu;
                        ps.memPercentage = (int)pmem;
                        ps.id = Integer.toString(pid);
                        ps.user = username;
                        ps.cmdLineArgs = ps.cmdLineNoArgs = LinuxStats.stripSquareBrackets(command);
                        ps.name = command.indexOf(47) == -1 ? command : command.substring(command.lastIndexOf("/") + 1);
                        processes.add(ps);
                    }
                    response = RunCommandGetOutput.runCommand(new String[]{"ps", "axo", "pid,comm"});
                    if (response != null && response.stdout != null) {
                        charStack = new CharStack(response.stdout);
                        charStack.popUntil('\n', false);
                        charStack.popWhitespace();
                        block9: while (!charStack.isEmpty()) {
                            int pid = (int)charStack.popInteger();
                            String id = Integer.toString(pid);
                            charStack.popWhitespace();
                            String commandPortion = charStack.popUntil('\n', true);
                            charStack.popWhitespace();
                            for (Stats.ProcessStatistic stat : processes) {
                                if (!stat.id.equals(id)) continue;
                                int lastIndexOfProcessNamePortion = stat.cmdLineArgs.indexOf(commandPortion);
                                if (lastIndexOfProcessNamePortion != -1) {
                                    int nextSpace = stat.cmdLineArgs.indexOf(32, lastIndexOfProcessNamePortion);
                                    if (nextSpace == -1) {
                                        nextSpace = stat.cmdLineArgs.length();
                                    }
                                    stat.cmdLineNoArgs = stat.cmdLineArgs.substring(0, nextSpace);
                                } else {
                                    int[] indices = new int[]{stat.cmdLineArgs.indexOf(" -"), stat.cmdLineArgs.indexOf(" :"), stat.cmdLineArgs.indexOf(" /")};
                                    int min = -1;
                                    for (int i : indices) {
                                        if (i <= -1) continue;
                                        min = min > -1 ? Math.min(min, i) : i;
                                    }
                                    if (min > -1) {
                                        stat.cmdLineNoArgs = stat.cmdLineArgs.substring(0, min);
                                    }
                                }
                                if (stat.cmdLineNoArgs.indexOf(47) == -1) {
                                    stat.name = stat.cmdLineNoArgs;
                                    continue block9;
                                }
                                if (stat.cmdLineNoArgs.startsWith("/")) {
                                    stat.name = stat.cmdLineNoArgs.substring(stat.cmdLineNoArgs.lastIndexOf("/") + 1);
                                    continue block9;
                                }
                                stat.name = stat.cmdLineNoArgs;
                                continue block9;
                            }
                        }
                    }
                    this.processStatistics = processes.toArray(new Stats.ProcessStatistic[0]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.updateUsedMemory();
            try {
                response = RunCommandGetOutput.runCommand(new String[]{"iwconfig"});
                if (response != null && response.returned()) {
                    CharStack cs = new CharStack(response.stdout);
                    cs.popUntil("Bit Rate=", false);
                    if (!cs.isEmpty()) {
                        this.wifiMbit = cs.popNumber();
                        cs.popUntil("Signal level=", false);
                        double dbm = cs.popNumber();
                        dbm += 100.0;
                        this.wifiPercentage = dbm *= 2.0;
                    }
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private static String stripSquareBrackets(String source) {
        if (source == null) {
            return null;
        }
        if (source.startsWith("[") && (source = source.substring(1)).endsWith("]")) {
            source = source.substring(0, source.length() - 1);
        }
        return source;
    }

    private void loadBatteryValues() {
        try {
            RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(new String[]{"upower", "-i", "/org/freedesktop/UPower/devices/battery_BAT0"});
            if (response != null && response.returned()) {
                HashMap<String, String> keyValueMap = StatsUtil.parseIntoKeyValueMap(response.stdout, ":");
                this.batteryPercentage = Integer.parseInt(keyValueMap.get("percentage"));
            }
        }
        catch (Throwable t) {
            this.batteryPercentage = 0;
        }
    }

    private double getCPUPercViaVMStat() throws Exception {
        RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(new String[]{"vmstat", "-n", "1", "2"}, null, true, true);
        if (response != null && response.returned()) {
            String[] lines = response.stdout.split("\\n");
            String[] headers = lines[1].trim().split("\\s+");
            String[] values = lines[3].trim().split("\\s+");
            for (int i = 0; i < values.length; ++i) {
                if (!headers[i].equals("id")) continue;
                return 100 - Integer.parseInt(values[i]);
            }
            return 100 - Integer.parseInt(values[values.length - 2]);
        }
        return 0.0;
    }

    private double getCPUPercViaIOStat() throws Exception {
        RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(new String[]{"iostat", "-c", "1", "2"}, null, true, true);
        CharStack charStack = new CharStack(response.stdout);
        charStack.popUntil('\n', false);
        charStack.popWhitespace();
        charStack.popUntil('\n', false);
        charStack.popWhitespace();
        charStack.popUntil('\n', false);
        charStack.popWhitespace();
        charStack.popUntil('\n', false);
        charStack.popWhitespace();
        double user = charStack.popNumber();
        charStack.popWhitespace();
        double nice = charStack.popNumber();
        charStack.popWhitespace();
        double system = charStack.popNumber();
        charStack.popWhitespace();
        double iowait = charStack.popNumber();
        charStack.popWhitespace();
        double steal = charStack.popNumber();
        charStack.popWhitespace();
        double idle = charStack.popNumber();
        return 100.0 - idle;
    }

    @Override
    public String killProcess(String pid) {
        RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand(new String[]{"kill", "-9", "" + pid});
        if (response != null) {
            if (response.returnCode == 0) {
                return null;
            }
            return response.stderr;
        }
        return null;
    }

    public static Stats.LocalPort[] getListeningApplications() {
        return LinuxStats.getListeningApplication(-1);
    }

    public static Stats.LocalPort[] getListeningApplication(int port) {
        String[] output = RunCommandGetOutput.runCommandGetOutput(new String[]{"netstat", "-antp"});
        String stdout = output[0];
        String[] lines = stdout.split("\n");
        ArrayList<Stats.LocalPort> results = new ArrayList<Stats.LocalPort>();
        boolean first = true;
        for (String line : lines) {
            if (first) {
                first = false;
                continue;
            }
            ArrayList<String> chunks = Chunker.chunk(line, false, true);
            try {
                Stats.LocalPort result = new Stats.LocalPort();
                String pid = chunks.get(6);
                String protocol = chunks.get(0);
                String local = chunks.get(3);
                int slice = pid.indexOf("/");
                if (slice != -1) {
                    pid = pid.substring(0, slice);
                    try {
                        result.pid = Integer.parseInt(pid);
                    }
                    catch (NumberFormatException e) {
                        result.pid = -1;
                    }
                }
                result.ip = local.substring(local.lastIndexOf(58));
                local = local.substring(local.lastIndexOf(":") + 1);
                result.port = Integer.parseInt(local);
                if (protocol.equalsIgnoreCase("TCP")) {
                    result.tcp = true;
                    if (!line.contains("LISTEN")) {
                        continue;
                    }
                } else if (protocol.equalsIgnoreCase("UDP")) {
                    result.udp = true;
                }
                if (port != -1 && result.port != port) continue;
                results.add(result);
            }
            catch (Exception x) {
                System.out.println("[LinuxStats] Ignored: " + line);
            }
        }
        return results.toArray(new Stats.LocalPort[0]);
    }

    @Override
    public void killProcessListeningOn(int port, boolean tcp, boolean udp) {
        String[] lines;
        String[] output = RunCommandGetOutput.runCommandGetOutput(new String[]{"netstat", "-antp"});
        String stdout = output[0];
        for (String line : lines = stdout.split("\n")) {
            ArrayList<String> chunks = Chunker.chunk(line, false, true);
            try {
                String pid = chunks.get(6);
                String protocol = chunks.get(0);
                String local = chunks.get(3);
                System.out.println(line);
                System.out.println(pid + " - (" + protocol + ") " + local);
                int slice = pid.indexOf("/");
                if (slice != -1) {
                    pid = pid.substring(0, slice);
                }
                local = local.substring(local.lastIndexOf(":") + 1);
                int lport = Integer.parseInt(local);
                boolean mustKill = false;
                if (tcp && (protocol.equalsIgnoreCase("tcp") || protocol.equalsIgnoreCase("tcp6")) && lport == port) {
                    mustKill = true;
                }
                if (udp && (protocol.equalsIgnoreCase("udp") || protocol.equalsIgnoreCase("udp6")) && lport == port) {
                    mustKill = true;
                }
                if (!mustKill) continue;
                System.out.println("Killing process " + pid);
                this.killProcess(pid);
            }
            catch (Exception x) {
                System.out.println("Ignored: " + line);
            }
        }
    }

    public static void main(String[] args) {
        LinuxStats stats = new LinuxStats();
        stats.update();
        System.out.println("Got " + stats.processStatistics.length);
        for (Stats.ProcessStatistic stat : stats.processStatistics) {
            System.out.println(stat.id);
            System.out.println(stat.name);
            System.out.println(stat.cmdLineArgs);
            System.out.println(stat.cmdLineNoArgs);
            System.out.println();
        }
    }
}

