/*
 * Decompiled with CFR 0.152.
 */
package utils.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import utils.files.FileUtil;

public class LuceneIndexer {
    private final File indexFile;
    private final File temporaryIndexFile;
    private boolean initialIndexRequired = false;

    public LuceneIndexer(File parentFolder) {
        this.indexFile = new File(parentFolder, "index");
        this.temporaryIndexFile = new File(parentFolder, ".index");
        if (!this.indexFile.exists()) {
            if (this.temporaryIndexFile.exists()) {
                FileUtil.deleteDir(this.temporaryIndexFile);
            }
            this.initialIndexRequired = true;
        } else if (this.indexFile.exists()) {
            this.initialIndexRequired = false;
        }
    }

    public void deleteAllIndexes() {
        if (this.temporaryIndexFile.exists()) {
            FileUtil.deleteDir(this.temporaryIndexFile);
        }
        if (this.indexFile.exists()) {
            FileUtil.deleteDir(this.indexFile);
        }
        this.initialIndexRequired = true;
    }

    public Directory initTempDirectory() throws IOException {
        System.out.println("[LuceneIndexer] Opening " + this.temporaryIndexFile);
        return FSDirectory.open((Path)this.temporaryIndexFile.toPath());
    }

    public boolean isInitialIndexRequired() {
        return this.initialIndexRequired;
    }

    public void renameTempDirectory() {
        FileUtil.deleteDir(this.indexFile);
        for (int i = 0; i < 10; ++i) {
            if (this.temporaryIndexFile.renameTo(this.indexFile)) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public FSDirectory initDirectory() throws IOException {
        System.out.println("[LuceneIndexer] Opening " + this.indexFile);
        return FSDirectory.open((Path)this.indexFile.toPath());
    }
}

