/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets.file;

import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.AbstractTargetUI;
import utils.loggingframework.targets.file.FileTarget;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class FileTargetUI
extends AbstractTargetUI {
    private ColorPropagatingGBPanel rootComponent = new ColorPropagatingGBPanel();
    private JLabel directoryLabel = new JLabel();
    private JLabel logNameLabel = new JLabel();
    private JTextField directoryField = new JTextField();
    private JTextField logNameField = new JTextField();
    private JCheckBox timeStampBox = new JCheckBox();
    private JCheckBox logAsXML = new JCheckBox();

    @Override
    public void notifyIfComplete() {
        if (this.directoryField.getText().length() > 0 && this.logNameField.getText().length() > 0) {
            this.notifyComplete();
        } else {
            this.notifyIncomplete();
        }
    }

    @Override
    protected void initUI() {
        this.logNameLabel.setText(this.bundle.getString("TARGET_UI_FILE_LOGNAME"));
        this.directoryLabel.setText(this.bundle.getString("TARGET_UI_FILE_DIRECTORY"));
        this.timeStampBox.setText(this.bundle.getString("TARGET_UI_FILE_TIMESTAMP"));
        this.logAsXML.setText(this.bundle.getString("TARGET_UI_FILE_XML"));
        this.rootComponent.add(this.logNameLabel, 0, 0, 1, 1, 0, 1, 13, 0, new Insets(3, 3, 3, 3));
        this.rootComponent.add(this.logNameField, 1, 0, 1, 1, 1, 1, 17, 0, new Insets(3, 3, 3, 3));
        this.rootComponent.add(this.directoryLabel, 0, 1, 1, 1, 0, 1, 13, 0, new Insets(3, 3, 3, 3));
        this.rootComponent.add(this.directoryField, 1, 1, 1, 1, 1, 1, 17, 0, new Insets(3, 3, 3, 3));
        this.rootComponent.add(this.logAsXML, 1, 2, 1, 1, 1, 1, 13, 2);
        this.rootComponent.add(this.timeStampBox, 1, 3, 1, 1, 1, 1, 13, 2);
        this.rootComponent.add(this.style.getPaddyPannel(true), 0, 4, 2, 1, 100, 100, 10, 1);
        SwingUtil.setWidth(this.logNameField, SimpleHelpLookAndFeel.scale(200));
        SwingUtil.setWidth(this.directoryField, SimpleHelpLookAndFeel.scale(300));
        this.directoryField.addKeyListener(this.changedAllListener);
        this.logNameField.addKeyListener(this.changedAllListener);
        this.timeStampBox.addActionListener(this.changedAllListener);
        this.logAsXML.addActionListener(this.changedAllListener);
        this.rootComponent.setBackground(this.style.getInnerBorderColor());
    }

    private void checkEnabled() {
        this.timeStampBox.setEnabled(!this.logAsXML.isSelected());
    }

    @Override
    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void populateTarget(AbstractTarget target) {
        if (!(target instanceof FileTarget)) {
            return;
        }
        FileTarget fileTarget = (FileTarget)target;
        fileTarget.logFileLocation = this.directoryField.getText();
        fileTarget.logFileName = this.logNameField.getText();
        fileTarget.timestamp = this.timeStampBox.isSelected();
        fileTarget.logAsXML = this.logAsXML.isSelected();
    }

    @Override
    public void initWithTarget(AbstractTarget target) {
        if (!(target instanceof FileTarget)) {
            return;
        }
        FileTarget ft = (FileTarget)target;
        this.directoryField.setText(ft.logFileLocation);
        this.logNameField.setText(ft.logFileName);
        this.timeStampBox.setSelected(ft.timestamp);
        this.logAsXML.setSelected(ft.logAsXML);
        this.checkEnabled();
    }
}

