/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets.email;

import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Element;
import utils.email.CommonEmailer;
import utils.loggingframework.events.EventRepository;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.TargetUI;
import utils.loggingframework.targets.email.EmailAddressMap;
import utils.loggingframework.targets.email.EmailTargetUI;
import utils.loggingframework.targets.email.EventEmailTemplate;
import utils.message.Message;
import utils.xml.XML14Util;

public class EmailTarget
extends AbstractTarget {
    public String[] toEmailAddresses;
    public EventEmailTemplate[] storedEmailTemplates;
    public static final String ID = "EmailTarget";

    @Override
    public String getName() {
        return this.bundle.getString("EMAIL_TARGET_NAME");
    }

    @Override
    public String getDescription() {
        return this.bundle.getString("EMAIL_TARGET_DESC");
    }

    @Override
    public String getTargetSummary() {
        return this.getName() + " " + Arrays.toString(this.toEmailAddresses);
    }

    private String[] substituteKeyAddresses(EmailAddressMap possibleEmailAddressesInEvent) {
        String[] result = new String[this.toEmailAddresses.length];
        for (int i = 0; i < this.toEmailAddresses.length; ++i) {
            int openBracketsIndex = this.toEmailAddresses[i].indexOf("${");
            int closeBracketsIndex = this.toEmailAddresses[i].indexOf("}");
            if (openBracketsIndex > -1 && closeBracketsIndex > -1) {
                String key = this.toEmailAddresses[i].substring(openBracketsIndex + 2, closeBracketsIndex);
                if (key != null && key.length() > 0) {
                    result[i] = possibleEmailAddressesInEvent.getEmailAddressForKey(key.trim());
                    continue;
                }
                result[i] = null;
                continue;
            }
            result[i] = this.toEmailAddresses[i];
        }
        return result;
    }

    private EventEmailTemplate getTemplateForEvent(LogEvent event) {
        if (this.storedEmailTemplates == null) {
            return null;
        }
        for (int i = 0; i < this.storedEmailTemplates.length; ++i) {
            EventEmailTemplate template = this.storedEmailTemplates[i];
            if (!template.isForEvent(event)) continue;
            return template;
        }
        return null;
    }

    @Override
    public void logEvent(LogEvent event) throws Exception {
        EmailAddressMap possibleEmailAddressesInEvent = event.getPossibleEmailAddressesInEvent();
        CommonEmailer emailUtil = EventRepository.INSTANCE.getEmailUtil();
        if (emailUtil != null) {
            EventEmailTemplate templateForEvent = this.getTemplateForEvent(event);
            if (templateForEvent != null) {
                String[] targetEmails;
                String mime = CommonEmailer.MIME_PLAIN_TEXT;
                if (templateForEvent.isHTML()) {
                    mime = CommonEmailer.MIME_HTML;
                }
                if ((targetEmails = this.substituteKeyAddresses(possibleEmailAddressesInEvent)) == null) {
                    return;
                }
                if ((targetEmails = this.pruneEmpty(targetEmails)).length == 0) {
                    return;
                }
                emailUtil.send(this.substituteKeyAddresses(possibleEmailAddressesInEvent), templateForEvent.getSubstitutedSubject(event), templateForEvent.getSubstitutedBody(event), mime, null);
            } else {
                System.out.println("[EmailTarget] Warning: there are no templates defined for this email log mapping.");
            }
        } else {
            System.out.println("[EmailTarget] Unable to set LogEvent email: no email server configured.");
        }
    }

    private String[] pruneEmpty(String[] targetEmails) {
        ArrayList<String> newAddresses = new ArrayList<String>();
        for (int i = 0; i < targetEmails.length; ++i) {
            String address = targetEmails[i];
            if (address == null || address.trim().length() <= 0) continue;
            newAddresses.add(address);
        }
        String[] result = new String[newAddresses.size()];
        newAddresses.toArray(result);
        return result;
    }

    @Override
    public boolean isAvailableTarget() {
        return EventRepository.INSTANCE.getEmailUtil() != null;
    }

    @Override
    public TargetUI getTargetUI() {
        return new EmailTargetUI();
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.toEmailAddresses);
        if (this.storedEmailTemplates == null) {
            m.append(0);
        } else {
            m.append(this.storedEmailTemplates.length);
            for (EventEmailTemplate s : this.storedEmailTemplates) {
                m.append(s.toMessage());
            }
        }
    }

    @Override
    public void fromMessage(byte verison, Message m) {
        this.toEmailAddresses = m.getNextStringArray();
        int templateCount = m.getNextInt();
        this.storedEmailTemplates = new EventEmailTemplate[templateCount];
        for (int i = 0; i < templateCount; ++i) {
            this.storedEmailTemplates[i] = EventEmailTemplate.fromMessage(m.getNextMessage());
        }
    }

    @Override
    protected void saveToXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(this.getID()).append(">\n");
        buffer.append(XML14Util.getIndent(indent + 1)).append("<toEmailAddresses>\n");
        if (this.toEmailAddresses != null) {
            for (String string : this.toEmailAddresses) {
                XML14Util.appendTextNode(buffer, indent + 2, "arrayelement", string);
            }
        }
        buffer.append(XML14Util.getIndent(indent + 1)).append("</toEmailAddresses>\n");
        buffer.append(XML14Util.getIndent(indent + 1)).append("<storedEmailTemplates>\n");
        if (this.storedEmailTemplates != null) {
            for (EventEmailTemplate eventEmailTemplate : this.storedEmailTemplates) {
                buffer.append(XML14Util.getIndent(indent + 2)).append("<arrayelement>\n");
                eventEmailTemplate.toXML(buffer, indent + 3);
                buffer.append(XML14Util.getIndent(indent + 2)).append("</arrayelement>\n");
            }
        }
        buffer.append(XML14Util.getIndent(indent + 1)).append("</storedEmailTemplates>\n");
        buffer.append(XML14Util.getIndent(indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void loadFromXML(Element root) {
        Element templatesParent;
        Element toEmailAddressesParent = XML14Util.getChild(root, "toEmailAddresses");
        if (toEmailAddressesParent != null) {
            ArrayList<Element> children = XML14Util.getChildren(toEmailAddressesParent, "arrayelement");
            ArrayList<String> addresses = new ArrayList<String>();
            for (Element e : children) {
                addresses.add(XML14Util.getTextContent(e));
            }
            this.toEmailAddresses = addresses.toArray(new String[0]);
        }
        if ((templatesParent = XML14Util.getChild(root, "storedEmailTemplates")) != null) {
            ArrayList<Element> children = XML14Util.getChildren(templatesParent, "arrayelement");
            ArrayList<EventEmailTemplate> templates = new ArrayList<EventEmailTemplate>();
            for (Element e : children) {
                EventEmailTemplate template = new EventEmailTemplate();
                template.loadFromXML(e);
                templates.add(template);
            }
            this.storedEmailTemplates = templates.toArray(new EventEmailTemplate[0]);
        }
    }
}

