/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.logmapping;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.filters.LogFilter;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.targets.AbstractTarget;
import utils.xml.XML14Util;

public class LogMappingImpl
implements LogMapping {
    private String name;
    private String[] eventIDs;
    private LogFilter[] filters = null;
    private AbstractTarget eventTarget;

    public LogMappingImpl(String name, String[] eventIDs, AbstractTarget target) {
        this(name, eventIDs, target, new LogFilter[0]);
    }

    public LogMappingImpl(String name, String[] eventIDs, AbstractTarget target, LogFilter[] filters) {
        this.name = name;
        this.eventTarget = target;
        this.filters = filters;
        this.eventIDs = eventIDs;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getLogMappingDescription() {
        return this.name;
    }

    public String getTargetName() {
        return this.eventTarget.getName();
    }

    public String getTargetSummary() {
        return this.eventTarget.getTargetSummary();
    }

    @Override
    public boolean canLogEvent(LogEvent event) {
        for (String supportedID : this.eventIDs) {
            if (!supportedID.equalsIgnoreCase(event.getID())) continue;
            if (this.filters == null || this.filters.length == 0) {
                return true;
            }
            for (int ii = 0; ii < this.filters.length; ++ii) {
                LogFilter filter = this.filters[ii];
                if (!filter.includeEvent(event)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public AbstractTarget getTarget() {
        return this.eventTarget;
    }

    public static LogMappingImpl loadFromXML(String xml, ResourceBundle bundle) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document dom = builder.parse(new InputSource(new StringReader(xml)));
        Element root = dom.getDocumentElement();
        return LogMappingImpl.loadFromXML(root, bundle);
    }

    public static LogMappingImpl loadFromXML(Element logMappingElement, ResourceBundle bundle) throws Exception {
        String name = logMappingElement.getAttribute("name");
        ArrayList<String> eventIDs = new ArrayList<String>();
        ArrayList<Element> childElements = XML14Util.getChildren(logMappingElement, "EventName");
        for (Element childElement : childElements) {
            String eventName = XML14Util.getTextContent(childElement).trim();
            eventIDs.add(eventName);
        }
        ArrayList<LogFilter> filters = new ArrayList<LogFilter>();
        childElements = XML14Util.getChildren(logMappingElement, "Filter");
        for (int i = 0; i < childElements.size(); ++i) {
            Element childElement = childElements.get(i);
            filters.add(LogFilter.loadFromXML(childElement));
        }
        LogFilter[] filterArray = filters.toArray(new LogFilter[0]);
        NodeList list = logMappingElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || ((Element)node).getTagName().equals("EventName") || ((Element)node).getTagName().equals("Filter")) continue;
            AbstractTarget target = AbstractTarget.fromXML((Element)node, bundle);
            return new LogMappingImpl(name, eventIDs.toArray(new String[0]), target, filterArray);
        }
        return null;
    }

    public String saveMappingToXML() throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t<LogMapping name=\"" + this.name + "\">\n");
        for (String id : this.eventIDs) {
            buffer.append("\t\t\t<EventName>" + id + "</EventName>\n");
        }
        buffer.append(this.eventTarget.saveToXML(3));
        if (this.filters != null) {
            for (int i = 0; i < this.filters.length; ++i) {
                buffer.append(this.filters[i].saveToXML(3));
            }
        }
        buffer.append("\t\t</LogMapping>\n");
        return buffer.toString();
    }

    @Override
    public LogFilter[] getFilters() {
        return this.filters;
    }

    @Override
    public String[] getLogEventIDs() {
        return this.eventIDs;
    }
}

