/*
 * Decompiled with CFR 0.152.
 */
package utils.json;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import utils.xml.XML14Util;

public class JSONUtil {
    public static String generateJSON(Object o) throws IllegalArgumentException, IllegalAccessException {
        return JSONUtil.generateJSON(null, o);
    }

    public static String generateJSON(String callBack, Object o) throws IllegalArgumentException, IllegalAccessException {
        StringBuffer buffer = new StringBuffer();
        JSONUtil.generateJSON(buffer, 0, o);
        if (callBack == null || callBack.length() == 0) {
            return buffer.toString();
        }
        return callBack + "(" + buffer.toString() + ");";
    }

    public static void generateJSON(StringBuffer buffer, int indent, Object o) throws IllegalArgumentException, IllegalAccessException {
        if (o == null) {
            return;
        }
        Class<?> c = o.getClass();
        if (c.isArray()) {
            int length = Array.getLength(o);
            buffer.append("[").append("\n");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buffer.append(",\n");
                }
                Object element = Array.get(o, i);
                JSONUtil.generateJSON(buffer, indent + 2, element);
            }
            buffer.append("\n");
            buffer.append(XML14Util.getIndent(indent)).append("]");
        } else if (c == String.class) {
            buffer.append("\"").append(String.valueOf(o)).append("\"");
        } else if (c == Double.TYPE || c == Integer.TYPE || c == Float.TYPE || c == Long.TYPE) {
            buffer.append(c);
        } else if (c == Double.class || c == Integer.class || c == Float.class || c == Long.class) {
            Number n = (Number)o;
            buffer.append(n.toString());
        } else if (c == Boolean.class) {
            buffer.append(o.toString());
        } else if (c == Boolean.TYPE) {
            buffer.append(c);
        } else {
            Field[] fields = c.getFields();
            buffer.append(XML14Util.getIndent(indent)).append("{").append("\n");
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                Object value = f.get(o);
                if (i > 0) {
                    buffer.append(",\n");
                }
                String name = f.getName();
                buffer.append(XML14Util.getIndent(indent + 1)).append("\"").append(name).append("\"").append(": ");
                JSONUtil.generateJSON(buffer, indent + 1, value);
            }
            buffer.append("\n");
            buffer.append(XML14Util.getIndent(indent)).append("}");
        }
    }
}

