/*
 * Decompiled with CFR 0.152.
 */
package utils.files.rafcache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import utils.files.rafcache.RAFileCache;

public class PooledRAFile {
    private final Object POOL_LOCK = new Object();
    private RAFileCache cache;
    private static HashMap countMap = new HashMap();
    public static int LIMIT = 1000;
    public static boolean USE_DEBUG_BREAK = false;

    public PooledRAFile(int max) {
        this.cache = new RAFileCache(max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile getRandomAccessFile(File file) throws FileNotFoundException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)this.cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                this.cache.addToCache(file, raFile);
            }
            return raFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLength(File file, long len) throws FileNotFoundException, IOException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            raFile.setLength(len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length(File file) throws FileNotFoundException, IOException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            return raFile.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(File file) throws FileNotFoundException, IOException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)this.cache.getFromCache(file);
            if (raFile != null) {
                this.cache.removeFromCache(file);
                raFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFilePointer(File file) throws FileNotFoundException, IOException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            return raFile.getFilePointer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, byte[] b, int off, int len) throws FileNotFoundException, IOException {
        if (USE_DEBUG_BREAK) {
            this.DEBUG_break_write(file, b, off, len);
            return;
        }
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            raFile.write(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, long seekto, byte[] b, int off, int len) throws FileNotFoundException, IOException {
        if (USE_DEBUG_BREAK) {
            this.DEBUG_break_write(file, b, off, len);
            return;
        }
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            raFile.seek(seekto);
            raFile.write(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, int b) throws FileNotFoundException, IOException {
        if (USE_DEBUG_BREAK) {
            this.DEBUG_break_write(file, b);
            return;
        }
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            raFile.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, byte[] b) throws FileNotFoundException, IOException {
        if (USE_DEBUG_BREAK) {
            this.DEBUG_break_write(file, b);
            return;
        }
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            raFile.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(File file, long pos) throws FileNotFoundException, IOException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            raFile.seek(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(File file) throws FileNotFoundException, IOException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            return raFile.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(File file, byte[] b, int off, int len) throws FileNotFoundException, IOException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            return raFile.read(b, off, len);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, InterruptedException {
        PooledRAFile file = new PooledRAFile(100);
        File test = new File("test");
        test.mkdir();
        for (int i = 0; i < 10000; ++i) {
            File target = new File(test, "" + i);
            file.write(target, new byte[]{0});
        }
        System.gc();
        System.gc();
        System.gc();
        Thread.sleep(10000L);
    }

    private static int incrementCount(File file) {
        Integer val = (Integer)countMap.get(file);
        if (val == null) {
            val = new Integer(0);
        }
        if ((val = new Integer(val + 1)) > LIMIT) {
            System.out.println("Exit after " + LIMIT + " bytes written to file " + file.getName());
            System.exit(1);
        }
        countMap.put(file, val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DEBUG_break_write(File file, byte[] b, int off, int len) throws FileNotFoundException, IOException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = this.getRandomAccessFile(file);
            for (int i = off; i < off + len; ++i) {
                raFile.write(b[i]);
                PooledRAFile.incrementCount(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DEBUG_break_write(File file, int b) throws FileNotFoundException, IOException {
        Object object = this.POOL_LOCK;
        synchronized (object) {
            RandomAccessFile raFile = (RandomAccessFile)this.cache.getFromCache(file);
            if (raFile == null) {
                raFile = new RandomAccessFile(file, "rw");
                this.cache.addToCache(file, raFile);
            }
            raFile.write(b);
            PooledRAFile.incrementCount(file);
        }
    }

    public void DEBUG_break_write(File file, byte[] b) throws FileNotFoundException, IOException {
        this.DEBUG_break_write(file, b, 0, b.length);
    }
}

