/*
 * Decompiled with CFR 0.152.
 */
package utils.files.rafcache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class Cache {
    HashMap map = new HashMap();
    LinkedCacheList list = new LinkedCacheList();
    int MAX_SIZE = 50;
    double hits = 0.0;
    double misses = 0.0;
    Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllCacheObjects() {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList list = new ArrayList(this.map.values());
            Object[] obj = list.toArray();
            for (int i = 0; i < obj.length; ++i) {
                LinkedEntry ent = (LinkedEntry)obj[i];
                obj[i] = ent.valueValue;
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.hits + this.misses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalHits() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.hits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalMisses() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.misses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getHitRatePercent() {
        Object object = this.LOCK;
        synchronized (object) {
            return 100.0 * (this.hits / (this.hits + this.misses));
        }
    }

    public Cache() {
    }

    public Cache(int max_size) {
        this.MAX_SIZE = max_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.map = new HashMap();
            this.list = new LinkedCacheList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(Object key, Object value) {
        Object object = this.LOCK;
        synchronized (object) {
            LinkedEntry e = (LinkedEntry)this.map.get(key);
            if (e != null) {
                e.valueValue = value;
            } else {
                this.map.put(key, this.list.add(key, value));
                if (this.map.size() > this.MAX_SIZE) {
                    LinkedEntry rm = this.list.removeFirst();
                    rm.next = null;
                    rm.prev = null;
                    if (rm != null) {
                        this.map.remove(rm.valueKey);
                        this.cleanup(rm.valueValue);
                    }
                }
            }
        }
    }

    protected void cleanup(Object value) {
    }

    public Object removeFromCache(Object key) {
        LinkedEntry e = (LinkedEntry)this.map.get(key);
        if (e == null) {
            return null;
        }
        this.list.remove(e);
        this.map.remove(key);
        return e.valueValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromCache(Object key) {
        Object object = this.LOCK;
        synchronized (object) {
            LinkedEntry e = (LinkedEntry)this.map.get(key);
            if (e == null) {
                this.misses += 1.0;
                return null;
            }
            this.hits += 1.0;
            this.list.moveToFront(e);
            return e.valueValue;
        }
    }

    public static void main(String[] args) throws Exception {
        Cache cache = new Cache(0);
        Random rand = new Random(5L);
        int hits = 0;
        int misses = 0;
        double COUNT = 2000000.0;
        double t = System.currentTimeMillis();
        int i = 0;
        while ((double)i < COUNT) {
            Integer key = new Integer(rand.nextInt(15));
            String value = (String)cache.getFromCache(key);
            if (value == null) {
                ++misses;
                value = "#" + key;
                cache.addToCache(key, value);
            } else {
                ++hits;
            }
            ++i;
        }
        t = (double)System.currentTimeMillis() - t;
        System.out.println(hits + " hits");
        System.out.println(misses + " misses");
        System.out.println("Cache size: " + cache.size());
        System.out.println(COUNT + " lookups in " + t + "ms");
        System.out.println(t / COUNT + " ms per lookups");
    }

    private class LinkedEntry {
        Object valueKey;
        Object valueValue;
        LinkedEntry prev;
        LinkedEntry next;

        private LinkedEntry() {
        }

        public String toString() {
            return "" + this.valueKey;
        }
    }

    private class LinkedCacheList {
        LinkedEntry start;
        LinkedEntry end;

        private LinkedCacheList() {
        }

        public LinkedEntry add(Object key, Object value) {
            LinkedEntry e = new LinkedEntry();
            e.valueKey = key;
            e.valueValue = value;
            e.next = null;
            if (this.end == null) {
                this.start = e;
                this.end = e;
                e.prev = null;
            } else {
                this.end.next = e;
                e.prev = this.end;
                this.end = e;
            }
            return e;
        }

        public void remove(LinkedEntry e) {
            if (this.start != null) {
                if (e == this.start && e == this.end) {
                    this.start = null;
                    this.end = null;
                    e.next = null;
                    e.prev = null;
                } else if (e == this.start) {
                    this.start = e.next;
                    e.next.prev = null;
                } else if (e == this.end) {
                    this.end = e.prev;
                    e.prev.next = null;
                } else {
                    e.prev.next = e.next;
                    e.next.prev = e.prev;
                }
            }
        }

        public LinkedEntry removeFirst() {
            if (this.start != null) {
                if (this.start == this.end) {
                    this.end = null;
                }
                LinkedEntry ret = this.start;
                this.start = this.start.next;
                if (this.start != null) {
                    this.start.prev = null;
                }
                return ret;
            }
            return null;
        }

        public void moveToFront(LinkedEntry e) {
            if (e != this.end) {
                if (e == this.start) {
                    this.start = e.next;
                    this.start.prev = null;
                } else {
                    e.prev.next = e.next;
                    e.next.prev = e.prev;
                }
                this.end.next = e;
                e.prev = this.end;
                e.next = null;
                this.end = e;
            }
        }
    }
}

