/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import utils.files.FileUtil;

public class RollingFileOutputStream
extends OutputStream {
    private ArrayList<RollListener> listeners = new ArrayList();
    private long maxFileSize;
    private final File initialTargetFile;
    private final long headSizeToReplicate;
    private final File targetArchiveFolder;
    private long currentFileSize;
    private int partCount;
    private FileOutputStream fout;
    private int lastHeaderLength;
    private boolean archivingEnabled;

    public RollingFileOutputStream(File initialTargetFile, long maxFileSize, long headSizeToReplicate, File targetArchiveFolder) throws FileNotFoundException {
        this.initialTargetFile = initialTargetFile;
        this.maxFileSize = maxFileSize;
        this.headSizeToReplicate = headSizeToReplicate;
        this.targetArchiveFolder = targetArchiveFolder;
        this.fout = new FileOutputStream(initialTargetFile);
        this.currentFileSize = 0L;
        this.partCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void roll() throws IOException {
        if (this.archivingEnabled && this.currentFileSize > this.maxFileSize) {
            File newTarget;
            try {
                this.fout.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.fout.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int part = this.partCount++;
            if (this.targetArchiveFolder == null) {
                newTarget = new File(this.initialTargetFile.getParentFile(), this.initialTargetFile.getName() + "." + part);
            } else {
                this.targetArchiveFolder.mkdirs();
                newTarget = new File(this.targetArchiveFolder, this.initialTargetFile.getName() + "." + part);
            }
            if (this.initialTargetFile.renameTo(newTarget)) {
                this.fout = new FileOutputStream(this.initialTargetFile);
                StringBuilder header = new StringBuilder();
                header.append("****************************************************\r\n");
                header.append("* ").append(this.initialTargetFile.getName());
                header.append(" Part:").append(part);
                header.append(" Created: ").append(DateFormat.getDateTimeInstance().format(new Date())).append("\r\n");
                header.append("****************************************************\r\n");
                if (this.headSizeToReplicate > 0L && this.headSizeToReplicate < this.maxFileSize) {
                    header.append("* Start Header\r\n");
                    header.append("****************************************************\r\n\r\n");
                    int newHeaderLength = header.length();
                    this.fout.write(header.toString().getBytes("UTF8"));
                    byte[] buffer = new byte[(int)Math.min(this.headSizeToReplicate, 50000L)];
                    BufferedInputStream bin = new BufferedInputStream(new FileInputStream(newTarget));
                    try {
                        int read;
                        bin.skip(this.lastHeaderLength);
                        for (long totalRead = 0L; totalRead < this.headSizeToReplicate; totalRead += (long)read) {
                            read = bin.read(buffer);
                            if (read == -1) {
                                break;
                            }
                            this.fout.write(buffer, 0, read);
                        }
                    }
                    finally {
                        FileUtil.robustClose(bin);
                    }
                    this.lastHeaderLength = newHeaderLength;
                    StringBuilder tail = new StringBuilder();
                    tail.append("****************************************************\r\n");
                    tail.append("* End Header\r\n");
                    tail.append("****************************************************\r\n\r\n");
                    this.fout.write(tail.toString().getBytes("UTF8"));
                }
                for (RollListener listener : this.listeners) {
                    listener.logRolled(newTarget);
                }
                this.currentFileSize = 0L;
            } else {
                this.fout = new FileOutputStream(this.initialTargetFile, true);
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.fout.write(b, off, len);
        this.currentFileSize += (long)len;
        this.roll();
    }

    @Override
    public void write(int b) throws IOException {
        this.fout.write(b);
        ++this.currentFileSize;
        this.roll();
    }

    @Override
    public void flush() throws IOException {
        this.fout.flush();
    }

    @Override
    public void close() throws IOException {
        this.fout.close();
    }

    public void addRollListener(RollListener listener) {
        this.listeners.add(listener);
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setArchiving(boolean archivingEnabled) {
        this.archivingEnabled = archivingEnabled;
    }

    public static interface RollListener {
        public void logRolled(File var1);
    }
}

