/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import utils.files.FileUtil;

public class AtomicFileOutputStream
extends OutputStream {
    private File file_final;
    private File file_interim;
    private File file_complete;
    private FileOutputStream fout_interim;
    private static boolean RANDOM_TESTING = false;
    private static final String INTERIM = ".afos_interim";
    private static final String COMPLETE = ".afos_complete";

    public AtomicFileOutputStream(String file) throws FileNotFoundException {
        this(new File(file));
    }

    public AtomicFileOutputStream(File file) throws FileNotFoundException {
        this.file_final = file;
        this.file_interim = new File(file + INTERIM);
        this.file_complete = new File(file + COMPLETE);
        this.fout_interim = new FileOutputStream(this.file_interim);
    }

    public static void prepareForReading(File f) throws FileNotFoundException {
        File src = new File(f.getAbsolutePath() + COMPLETE);
        if (src.exists()) {
            try {
                System.out.println("[AFOS] Completing unfinished write to " + f + " before opening for reading");
                FileUtil.copy(src, f);
            }
            catch (Exception x) {
                System.out.println("[AFOS] Unable to complete unfinished write to " + f + " - " + x);
            }
            try {
                src.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File " + f + " not found");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fout_interim == null) {
            return;
        }
        try {
            this.fout_interim.flush();
        }
        finally {
            this.fout_interim.close();
            this.fout_interim = null;
        }
        if (RANDOM_TESTING && Math.random() < 0.4) {
            System.out.println("[AFOS] Simulating failure to finish this write properly");
            return;
        }
        boolean renamedOK = false;
        try {
            renamedOK = this.file_interim.renameTo(this.file_complete);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File source = renamedOK ? this.file_complete : this.file_interim;
        if (RANDOM_TESTING && Math.random() < 0.4) {
            System.out.println("[AFOS] Simulating failure to perform copy");
            return;
        }
        if (RANDOM_TESTING && Math.random() < 0.4) {
            FileOutputStream fout = new FileOutputStream(this.file_final);
            fout.write(4);
            fout.close();
            return;
        }
        FileUtil.copy(source, this.file_final);
        try {
            this.file_interim.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.file_complete.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.fout_interim == null) {
            throw new IOException("AFOS Closed");
        }
        this.fout_interim.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.fout_interim == null) {
            throw new IOException("AFOS Closed");
        }
        this.fout_interim.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.fout_interim == null) {
            throw new IOException("AFOS Closed");
        }
        this.fout_interim.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.fout_interim == null) {
            throw new IOException("AFOS Closed");
        }
        this.fout_interim.write(b);
    }

    public static void main(String[] args) throws Exception {
        String dat = "";
        for (int i = 0; i < 500; ++i) {
            dat = dat + "" + i;
        }
        long t = System.currentTimeMillis() + 5000L;
        int count = 0;
        while (System.currentTimeMillis() < t) {
            dat = dat + "x";
            File file = new File("afos_test");
            AtomicFileOutputStream out = new AtomicFileOutputStream(file);
            ((OutputStream)out).write(dat.getBytes("UTF8"));
            ((OutputStream)out).close();
            ++count;
            RANDOM_TESTING = false;
            if (!file.exists()) {
                System.out.println("[AFOS Testing] FILE SHOULD EXIST BUT DOES NOT!");
                return;
            }
            if (!RANDOM_TESTING) continue;
            AtomicFileOutputStream.prepareForReading(file);
            String readok = FileUtil.readFileAsStringUTF8(file);
            if (dat.equals(readok)) continue;
            if (dat.startsWith(readok)) {
                System.out.println("[AFOS Testing] File data is OLD but that is OK");
                continue;
            }
            System.out.println("[AFOS Testing] FILE DATA IS WRONG!");
            System.out.println(readok);
            return;
        }
        if (!RANDOM_TESTING) {
            System.out.println(count / 5 + " per second");
        }
    }
}

